/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

static const char rcsid[] = "$Id: syslog.c 96 2009-01-20 15:34:19Z loos-br $";

#include <syslog.h>
#include <stdarg.h>

#include "io.h"
#include "syslog.h"

void start_log(log_ *l, char *ident) {
    l->protocol = log_null;
    l->debug	= log_null;
    l->info	= log_null;
    l->sql	= log_null;
//    openlog(ident, LOG_NDELAY | LOG_PID, LOG_DAEMON);
}

void log(const char *fmt, ...) {
 va_list ap;

    va_start(ap, fmt);

//    vsyslog(LOG_WARNING, fmt, ap);
    io_vprintf(1, fmt, ap);

    va_end(ap);
}

void log_null(const char *fmt, ...) { return; }
