/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import java.util.Map;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.NullObject;

public class Invoker {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final Class[] EMPTY_TYPES = new Class[0];
    private MetaClassRegistry metaRegistry = new MetaClassRegistry();

    public MetaClassRegistry getMetaRegistry() {
        return this.metaRegistry;
    }

    public MetaClass getMetaClass(Object object) {
        return this.metaRegistry.getMetaClass(object.getClass());
    }

    public Object invokeMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            Class theClass = (Class)object;
            MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object, methodName, this.asArray(arguments));
        }
        if (!(object instanceof GroovyObject)) {
            Class<?> theClass = object.getClass();
            MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
            return metaClass.invokeMethod(object, methodName, this.asArray(arguments));
        }
        GroovyObject groovy = (GroovyObject)object;
        try {
            if (groovy instanceof GroovyInterceptable) {
                return groovy.invokeMethod(methodName, this.asArray(arguments));
            }
            return groovy.getMetaClass().invokeMethod(object, methodName, this.asArray(arguments));
        }
        catch (MissingMethodException e) {
            if (e.getMethod().equals(methodName) && object.getClass() == e.getType()) {
                return groovy.invokeMethod(methodName, this.asArray(arguments));
            }
            throw e;
        }
    }

    public Object invokeSuperMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method " + methodName + "() on null object");
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = this.metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object, methodName, this.asArray(arguments));
    }

    public Object invokeStaticMethod(Class type, String method, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(type);
        return metaClass.invokeStaticMethod(type, method, this.asArray(arguments));
    }

    public Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(this.asArray(arguments));
    }

    public Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public Object getProperty(Object object, String property) {
        if (object == null) {
            throw new NullPointerException("Cannot get property: " + property + " on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            return pogo.getProperty(property);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.get(property);
        }
        if (object instanceof Class) {
            Class c = (Class)object;
            return this.metaRegistry.getMetaClass(c).getProperty(object, property);
        }
        return this.metaRegistry.getMetaClass(object.getClass()).getProperty(object, property);
    }

    public void setProperty(Object object, String property, Object newValue) {
        if (object == null) {
            throw new GroovyRuntimeException("Cannot set property on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            pogo.setProperty(property, newValue);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.put(property, newValue);
        } else if (object instanceof Class) {
            this.metaRegistry.getMetaClass((Class)object).setProperty((Class)object, property, newValue);
        } else {
            this.metaRegistry.getMetaClass(object.getClass()).setProperty(object, property, newValue);
        }
    }

    public Object getAttribute(Object object, String attribute) {
        if (object == null) {
            throw new NullPointerException("Cannot get attribute: " + attribute + " on null object");
        }
        if (object instanceof Class) {
            return this.metaRegistry.getMetaClass((Class)object).getAttribute(object, attribute);
        }
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass().getAttribute(object, attribute);
        }
        return this.metaRegistry.getMetaClass(object.getClass()).getAttribute(object, attribute);
    }

    public void setAttribute(Object object, String attribute, Object newValue) {
        if (object == null) {
            throw new GroovyRuntimeException("Cannot set attribute on null object");
        }
        if (object instanceof Class) {
            this.metaRegistry.getMetaClass((Class)object).setAttribute(object, attribute, newValue);
        } else if (object instanceof GroovyObject) {
            ((GroovyObject)object).getMetaClass().setAttribute(object, attribute, newValue);
        } else {
            this.metaRegistry.getMetaClass(object.getClass()).setAttribute(object, attribute, newValue);
        }
    }

    public Closure getMethodPointer(Object object, String methodName) {
        if (object == null) {
            throw new NullPointerException("Cannot access method pointer for '" + methodName + "' on null object");
        }
        return MetaClassHelper.getMethodPointer(object, methodName);
    }

    public void removeMetaClass(Class clazz) {
        this.getMetaRegistry().removeMetaClass(clazz);
    }
}

