/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.JRCalculator;

public class JRBshCalculator
extends JRCalculator {
    private String bshScript = null;
    private Interpreter interpreter = null;

    public JRBshCalculator(String string) throws JRException {
        this.bshScript = string;
        this.interpreter = new Interpreter();
        this.interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            this.interpreter.eval(new StringReader(string));
        }
        catch (EvalError evalError) {
            throw new JRException("Error evaluating report expressions BeanShell script.\nMessage : " + evalError.getMessage() + "\nLine " + evalError.getErrorLineNumber() + " : " + this.extractLineContent(evalError));
        }
    }

    public void verify(Collection collection) throws JRException {
        try {
            this.interpreter.eval("bshCalculator = createBshCalculator()");
            if (collection != null) {
                for (JRExpression jRExpression : collection) {
                    this.interpreter.eval("bshCalculator.evaluateOld(" + jRExpression.getId() + ")");
                }
            }
        }
        catch (TargetError targetError) {
        }
        catch (EvalError evalError) {
            throw new JRException("Error testing report expressions BeanShell script.\nMessage : " + evalError.getMessage() + "\nLine " + evalError.getErrorLineNumber() + " : " + this.extractLineContent(evalError));
        }
    }

    protected void customizedInit(Map map, Map map2, Map map3) throws JRException {
        try {
            this.interpreter.set("calculator", this);
            this.interpreter.set("fldsm", map2);
            this.interpreter.set("varsm", map3);
            this.interpreter.set("parsm", map);
            this.interpreter.eval("bshCalculator = createBshCalculator()");
            this.interpreter.eval("bshCalculator.init(calculator, parsm, fldsm, varsm)");
        }
        catch (EvalError evalError) {
            throw new JRException("Error initializing report BeanShell calculator.", evalError);
        }
    }

    protected Object evaluateOld(int n) throws Throwable {
        try {
            return this.interpreter.eval("bshCalculator.evaluateOld(" + n + ")");
        }
        catch (TargetError targetError) {
            throw targetError.getTarget();
        }
        catch (EvalError evalError) {
            throw evalError;
        }
    }

    protected Object evaluateEstimated(int n) throws Throwable {
        try {
            return this.interpreter.eval("bshCalculator.evaluateEstimated(" + n + ")");
        }
        catch (TargetError targetError) {
            throw targetError.getTarget();
        }
        catch (EvalError evalError) {
            throw evalError;
        }
    }

    protected Object evaluate(int n) throws Throwable {
        try {
            return this.interpreter.eval("bshCalculator.evaluate(" + n + ")");
        }
        catch (TargetError targetError) {
            throw targetError.getTarget();
        }
        catch (EvalError evalError) {
            throw evalError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractLineContent(EvalError evalError) {
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new LineNumberReader(new StringReader(this.bshScript));
            int n = evalError.getErrorLineNumber();
            for (int i = 0; i < n; ++i) {
                string = ((LineNumberReader)bufferedReader).readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }
}

