/*
 * Decompiled with CFR 0.152.
 */
package com.projity.exchange;

import com.projity.exchange.LocalFileImporter;
import com.projity.exchange.ResourceMappingForm;
import com.projity.exchange.ServerFileImporter;
import com.projity.job.Job;
import com.projity.job.JobCanceledException;
import com.projity.job.JobRunnable;
import com.projity.pm.resource.Resource;
import com.projity.pm.task.Project;
import com.projity.server.data.AssignmentData;
import com.projity.server.data.DistributionData;
import com.projity.server.data.EnterpriseResourceData;
import com.projity.server.data.ProjectData;
import com.projity.server.data.ResourceData;
import com.projity.server.data.SerializedDataObject;
import com.projity.server.data.Serializer;
import com.projity.server.data.TaskData;
import com.projity.session.Session;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ServerLocalFileImporter
extends ServerFileImporter {
    private static final String ABORT = "Job aborted";
    protected ProjectData projectData;
    Map<Long, Resource> _localResourceMap;

    public void importFile() throws Exception {
    }

    public void exportFile() throws Exception {
    }

    public Job getImportFileJob() {
        final Serializer serializer = new Serializer();
        final ServerLocalFileImporter serverLocalFileImporter = this;
        Job job = new Job(serverLocalFileImporter.getJobQueue(), "importFile", Messages.getString("LocalFileImporter.Importing"), true);
        job.addRunnable(new JobRunnable("Import", 1.0f){

            public Object run() throws Exception {
                System.out.println("Loading " + serverLocalFileImporter.getFileName() + "...");
                long l = System.currentTimeMillis();
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(serverLocalFileImporter.getFileName()));
                Object object = objectInputStream.readObject();
                if (object instanceof String) {
                    object = objectInputStream.readObject();
                }
                ServerLocalFileImporter.this.projectData = (ProjectData)object;
                ServerLocalFileImporter.this.projectData.setMaster(false);
                ServerLocalFileImporter.this.projectData.setLocal(false);
                long l2 = System.currentTimeMillis();
                System.out.println("Loading...Done in " + (l2 - l) + " ms");
                Collection collection = ServerLocalFileImporter.this.projectData.getResources();
                ArrayList<EnterpriseResourceData> arrayList = new ArrayList<EnterpriseResourceData>(collection.size());
                for (ResourceData resourceData : collection) {
                    arrayList.add(resourceData.getEnterpriseResource());
                }
                ((ServerFileImporter)serverLocalFileImporter).prepareResources(arrayList, null, false);
                ServerLocalFileImporter.this.renumberProject();
                this.setProgress(1.0f);
                return null;
            }
        });
        job.addSwingRunnable(new JobRunnable("Import resources", 1.0f){

            public Object run() throws Exception {
                ResourceMappingForm resourceMappingForm = ServerLocalFileImporter.this.getResourceMapping();
                if (resourceMappingForm != null && resourceMappingForm.isLocal() && !this.job.okCancel(Messages.getString("Message.ServerUnreacheableReadOnlyProject"), true)) {
                    this.setProgress(1.0f);
                    throw new Exception(ServerLocalFileImporter.ABORT);
                }
                if (!ServerLocalFileImporter.this.importResources()) {
                    this.setProgress(1.0f);
                    throw new JobCanceledException(ServerLocalFileImporter.ABORT);
                }
                this.setProgress(1.0f);
                return null;
            }
        });
        job.addRunnable(new JobRunnable("Import", 1.0f){

            public Object run() throws Exception {
                System.out.println("Deserializing...");
                long l = System.currentTimeMillis();
                ResourceMappingForm resourceMappingForm = ServerLocalFileImporter.this.getResourceMapping();
                Project project = serializer.deserializeProject(ServerLocalFileImporter.this.projectData, false, null, null, null, false);
                if (project != null && !Environment.getStandAlone()) {
                    project.setAllDirty();
                }
                serverLocalFileImporter.setProject(project);
                long l2 = System.currentTimeMillis();
                System.out.println("Deserializing...Done in " + (l2 - l) + " ms");
                project.setGroupDirty(!Environment.getStandAlone());
                project.setTemporaryLocal(true);
                project.setAccessControlPolicy(resourceMappingForm.getAccessControlType());
                project.resetRoles(resourceMappingForm.getAccessControlType() == 0);
                if (resourceMappingForm.isLocal()) {
                    project.setLocal(true);
                }
                this.setProgress(1.0f);
                return null;
            }
        });
        return job;
    }

    protected boolean importResources() throws Exception {
        ResourceMappingForm resourceMappingForm = this.getResourceMapping();
        if (resourceMappingForm != null && !resourceMappingForm.isLocal()) {
            Object object;
            Object object22;
            Object object3;
            Object object4;
            Serializable serializable2;
            if (!resourceMappingForm.execute()) {
                return false;
            }
            if (resourceMappingForm.isLocal()) {
                return true;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
            for (Serializable serializable2 : resourceMappingForm.getResources()) {
                if (((SerializedDataObject)serializable2).getUniqueId() == -65535L) continue;
                object4 = new ResourceData();
                ((ResourceData)object4).setEnterpriseResource((EnterpriseResourceData)serializable2);
                hashMap.put(((SerializedDataObject)serializable2).getUniqueId(), object4);
                arrayList.add(object4);
            }
            this.projectData.setResources(arrayList);
            serializable2 = new HashMap();
            object4 = resourceMappingForm.getImportedResources().iterator();
            Iterator iterator = resourceMappingForm.getSelectedResources().iterator();
            while (object4.hasNext()) {
                object3 = (EnterpriseResourceData)object4.next();
                object22 = (EnterpriseResourceData)iterator.next();
                if (((SerializedDataObject)object22).getUniqueId() == -65535L) continue;
                object = new ResourceData();
                ((ResourceData)object).setEnterpriseResource((EnterpriseResourceData)object22);
                serializable2.put(((SerializedDataObject)object3).getUniqueId(), hashMap.get(((SerializedDataObject)object22).getUniqueId()));
            }
            for (Object object22 : this.projectData.getTasks()) {
                if (((TaskData)object22).getAssignments() == null) continue;
                for (SerializedDataObject serializedDataObject : ((TaskData)object22).getAssignments()) {
                    ResourceData resourceData = (ResourceData)serializable2.get(serializedDataObject.getUniqueId());
                    if (resourceData == null) {
                        ((AssignmentData)serializedDataObject).setResource(null);
                        ((AssignmentData)serializedDataObject).setResourceId(-1L);
                        continue;
                    }
                    ((AssignmentData)serializedDataObject).setResource(resourceData.getEnterpriseResource());
                    ((AssignmentData)serializedDataObject).setResourceId(resourceData.getEnterpriseResource().getUniqueId());
                }
            }
            object3 = this.projectData.getDistributions();
            if (object3 != null) {
                object22 = object3.iterator();
                while (object22.hasNext()) {
                    SerializedDataObject serializedDataObject;
                    object = (DistributionData)object22.next();
                    serializedDataObject = (ResourceData)serializable2.get(((DistributionData)object).getResourceId());
                    if (serializedDataObject == null) {
                        object22.remove();
                        continue;
                    }
                    ((DistributionData)object).setResourceId(((ResourceData)serializedDataObject).getEnterpriseResource().getUniqueId());
                }
            }
        }
        return true;
    }

    protected void retrieveResourcesForMerge(Project project) throws Exception {
        ResourceMappingForm resourceMappingForm = this.getResourceMapping();
        if (resourceMappingForm == null) {
            return;
        }
        Vector<EnterpriseResourceData> vector = new Vector<EnterpriseResourceData>();
        this._localResourceMap = new HashMap<Long, Resource>();
        EnterpriseResourceData enterpriseResourceData = new EnterpriseResourceData();
        enterpriseResourceData.setUniqueId(-65535L);
        enterpriseResourceData.setName(Messages.getString("Text.Unassigned"));
        resourceMappingForm.setUnassignedResource(enterpriseResourceData);
        vector.add(enterpriseResourceData);
        Serializer serializer = new Serializer();
        ProjectData projectData = (ProjectData)serializer.serialize(project, ProjectData.FACTORY, null);
        if (project.isForceNonIncremental()) {
            projectData.setVersion(0.0f);
        }
        projectData.setMaster(project.isMaster());
        Map map = serializer.saveResources(project, projectData);
        ArrayList arrayList = project.getResourcePool().getResourceList();
        for (Resource resource : arrayList) {
            ResourceData resourceData;
            if (resource == null || (resourceData = (ResourceData)map.get(resource.getUniqueId())) == null) continue;
            EnterpriseResourceData enterpriseResourceData2 = resourceData.getEnterpriseResource();
            enterpriseResourceData2.setName(resource.getName());
            vector.add(enterpriseResourceData2);
            this._localResourceMap.put(resourceData.getUniqueId(), resource);
        }
        resourceMappingForm.setResources(vector);
    }

    protected void renumberProject() throws Exception {
        Session session = SessionFactory.getInstance().getSession(false);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        for (Object object : this.projectData.getTasks()) {
            long l = ((SerializedDataObject)object).getUniqueId();
            long l2 = session.getId();
            ((SerializedDataObject)object).setUniqueId(l2);
            hashMap.put(l, l2);
            if (((TaskData)object).getAssignments() == null) continue;
            for (AssignmentData assignmentData : ((TaskData)object).getAssignments()) {
                assignmentData.setTaskId(l2);
            }
        }
        Collection collection = this.projectData.getDistributions();
        if (collection != null) {
            Object object;
            object = collection.iterator();
            while (object.hasNext()) {
                DistributionData distributionData = (DistributionData)object.next();
                distributionData.setTaskId((Long)hashMap.get(distributionData.getTaskId()));
            }
        }
        this.projectData.setUniqueId(session.getId());
    }

    public Job getExportFileJob() {
        return LocalFileImporter.getExportFileJob(this);
    }

    public boolean saveProject(Project project, OutputStream outputStream) throws Exception {
        return false;
    }

    public Project loadProject(InputStream inputStream) throws Exception {
        return null;
    }
}

