/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network;

import com.projity.field.FieldParseException;
import com.projity.pm.graphic.graph.GraphInteractor;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.network.NetworkRenderer;
import com.projity.pm.graphic.network.NetworkUI;
import com.projity.pm.graphic.network.rendering.FieldChange;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class NetworkInteractor
extends GraphInteractor {
    private static final long serialVersionUID = 5365103090789265267L;
    protected static final int BAR_SELECTION = 4;

    public NetworkInteractor(GraphUI graphUI) {
        super(graphUI);
    }

    protected void computeNodeSelection(double d, double d2) {
        this.state = ((NetworkUI)this.ui).isOnBarEdge((GraphicNode)this.selected, d, d2) ? 3 : 4;
    }

    protected Shape getBarShadowBounds(double d, double d2) {
        GraphicNode graphicNode = (GraphicNode)this.selected;
        GeneralPath generalPath = this.getShape(graphicNode);
        return generalPath.createTransformedShape(AffineTransform.getTranslateInstance(d - this.x0, d2 - this.y0));
    }

    protected GeneralPath getShape(GraphicNode graphicNode) {
        return ((NetworkRenderer)((NetworkUI)this.ui).getGraphRenderer()).getShape(graphicNode);
    }

    protected Rectangle2D getLinkSelectionShadowBounds(GraphicNode graphicNode) {
        GeneralPath generalPath = this.getShape(graphicNode);
        return generalPath.getBounds2D();
    }

    protected void setLinkOrigin() {
        GraphicNode graphicNode = (GraphicNode)this.selected;
        Point2D point2D = ((NetworkRenderer)((NetworkUI)this.ui).getGraphRenderer()).getCenter(graphicNode);
        this.x0link = point2D.getX();
        this.y0link = point2D.getY();
    }

    protected boolean switchOnLinkCreation(double d, double d2) {
        if (this.state != 4) {
            return false;
        }
        GraphicNode graphicNode = (GraphicNode)this.selected;
        GeneralPath generalPath = this.getShape(graphicNode);
        if (generalPath == null) {
            return false;
        }
        return generalPath.contains(d, d2);
    }

    protected void select(int n, int n2) {
        if (this.selection) {
            this.selectedZone = this.ui.getObjectAt(n, n2);
            if (this.selectedZone != null) {
                this.selected = this.selectedZone.getObject();
            }
            int n3 = this.state;
            if (this.selected == null) {
                this.state = 0;
            } else {
                this.findState(n, n2);
            }
            if (this.state != n3) {
                if (n3 == 4) {
                    NetworkUI networkUI = (NetworkUI)this.ui;
                    List list = networkUI.getEditorChange();
                    GraphicNode graphicNode = networkUI.getEditorNode();
                    networkUI.editNode(null);
                    if (list != null) {
                        for (FieldChange fieldChange : list) {
                            try {
                                networkUI.getGraph().getCache().getModel().setFieldValue(fieldChange.getField(), graphicNode.getNode(), this, fieldChange.getValue(), null, 3);
                            }
                            catch (FieldParseException fieldParseException) {
                                fieldParseException.printStackTrace();
                            }
                        }
                    }
                }
                this.selectCursor();
            }
        }
    }

    public boolean executeAction(double d, double d2) {
        if (this.selected == null) {
            return false;
        }
        switch (this.state) {
            case 4: {
                ((NetworkUI)this.ui).editNode((GraphicNode)this.selected);
                return true;
            }
            case 3: {
                ((NetworkRenderer)((NetworkUI)this.ui).getGraphRenderer()).translateShape((GraphicNode)this.selected, d - this.x0, d2 - this.y0);
                return true;
            }
        }
        return false;
    }
}

