/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.configuration.Dictionary;
import com.projity.document.Document;
import com.projity.field.FieldContext;
import com.projity.graphic.configuration.CellStyle;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.help.HelpUtil;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.views.BaseView;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourcePool;
import com.projity.strings.Messages;
import com.projity.undo.UndoController;
import com.projity.util.Alert;
import com.projity.util.Environment;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Component;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public class ResourceView
extends JScrollPane
implements BaseView {
    private static final long serialVersionUID = 591334548533168582L;
    public static final String spreadsheetCategory = "resourceSpreadsheet";
    protected SpreadSheet spreadSheet;
    protected NodeModel model;
    protected NodeModelCache cache;
    Document document;
    FieldContext fieldContext;
    CellStyle cellStyle;
    boolean readOnly;

    public ResourceView(ReferenceNodeModelCache referenceNodeModelCache, NodeModel nodeModel, Document document, boolean bl, boolean bl2) {
        HelpUtil.addDocHelp(this, "Resource_View");
        this.model = nodeModel;
        this.document = document;
        this.cache = NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, this.getViewName(), null);
        this.fieldContext = new FieldContext();
        this.fieldContext.setLeftAssociation(false);
        this.createSpreadsheet();
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.spreadSheet);
        this.setViewport(jViewport);
        referenceNodeModelCache.update();
        if (!bl2 && !Environment.isOpenProj()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Alert.warnWithOnceOption(Messages.getString("Info.resourceView"), "warnedResourceView");
                }
            });
        }
    }

    public void cleanUp() {
        this.spreadSheet.cleanUp();
        this.spreadSheet = null;
        this.model = null;
        this.cache = null;
        this.document = null;
        this.fieldContext = null;
        this.cellStyle = null;
    }

    public void createSpreadsheet() {
        this.spreadSheet = new SpreadSheet(){

            private Object getEntryInRow(int n) {
                Node node = ((SpreadSheetModel)this.getModel()).getNode(n).getNode();
                if (node != null && !node.isVirtual()) {
                    return node.getImpl();
                }
                return null;
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                return component;
            }

            public boolean isNodeDeletable(Node node) {
                if (node != null && node.getImpl() instanceof Resource) {
                    Resource resource = (Resource)node.getImpl();
                    if (resource.isUser()) {
                        Alert.warn(Messages.getString("ResourceView.YouCannotDeleteTheResource") + resource.getName() + Messages.getString("ResourceView.UsersCanOnlyBeRemoved"));
                        return false;
                    }
                    if (resource.isAssignedToSomeProject()) {
                        Alert.warn(Messages.getString("ResourceView.YouCannotDeleteTheResource") + resource.getName() + Messages.getString("ResourceView.ThisResourceCurrentlyHasAssignments"));
                        return false;
                    }
                    List list = node.getChildren();
                    if (list != null) {
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            Node node2 = (Node)listIterator.next();
                            if (this.isNodeDeletable(node2)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }

            public boolean isNodeCuttable(Node node) {
                if (node != null && node.getImpl() instanceof Resource) {
                    Resource resource = (Resource)node.getImpl();
                    if (resource.isUser()) {
                        Alert.warn(Messages.getString("ResourceView.YouCannotDeleteTheResource") + resource.getName() + Messages.getString("ResourceView.UsersCanOnlyBeRemoved") + "\n" + Messages.getString("ResourceView.ToMoveAProtectedResource"));
                        return false;
                    }
                    if (resource.isAssignedToSomeProject()) {
                        Alert.warn(Messages.getString("ResourceView.YouCannotDeleteTheResource") + resource.getName() + Messages.getString("ResourceView.ThisResourceCurrentlyHasAssignments") + "\n" + Messages.getString("ResourceView.ToMoveAProtectedResource"));
                        return false;
                    }
                    List list = node.getChildren();
                    if (list != null) {
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            Node node2 = (Node)listIterator.next();
                            if (this.isNodeDeletable(node2)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        };
        this.spreadSheet.setSpreadSheetCategory(spreadsheetCategory);
        SpreadSheetFieldArray spreadSheetFieldArray = ResourceView.getFields();
        if (((ResourcePool)this.document).isMaster()) {
            spreadSheetFieldArray = (SpreadSheetFieldArray)spreadSheetFieldArray.clone();
            spreadSheetFieldArray.removeField("Field.userRole");
        }
        this.spreadSheet.setCache(this.cache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        ((SpreadSheetModel)this.spreadSheet.getModel()).setFieldContext(this.fieldContext);
        this.spreadSheet.setReadOnly(this.readOnly);
    }

    private static SpreadSheetFieldArray getFields() {
        return (SpreadSheetFieldArray)Dictionary.get(spreadsheetCategory, Messages.getString("Spreadsheet.Resource.entryWorkResources"));
    }

    public SpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }

    public UndoController getUndoController() {
        return ((ResourcePool)this.document).getUndoController();
    }

    public void zoomIn() {
    }

    public void zoomOut() {
    }

    public boolean canZoomIn() {
        return false;
    }

    public boolean canZoomOut() {
        return false;
    }

    public int getScale() {
        return -1;
    }

    public boolean hasNormalMinWidth() {
        return true;
    }

    public String getViewName() {
        return "Resources";
    }

    public boolean showsTasks() {
        return false;
    }

    public boolean showsResources() {
        return true;
    }

    public void onActivate(boolean bl) {
    }

    public boolean isPrintable() {
        return true;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.spreadSheet.restoreWorkspace(workspace.spreadSheet, n);
    }

    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.spreadSheet = this.spreadSheet.createWorkspace(n);
        return workspace;
    }

    public boolean canScrollToTask() {
        return false;
    }

    public void scrollToTask() {
    }

    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -1251204386431239291L;
        WorkspaceSetting spreadSheet;

        public WorkspaceSetting getSpreadSheet() {
            return this.spreadSheet;
        }

        public void setSpreadSheet(WorkspaceSetting workspaceSetting) {
            this.spreadSheet = workspaceSetting;
        }
    }
}

