/*
 * Decompiled with CFR 0.152.
 */
package com.projity.script;

import com.projity.configuration.Dictionary;
import com.projity.configuration.NamedItem;
import com.projity.field.Field;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.strings.Messages;
import java.util.Iterator;

public class FieldArrayUtil {
    public static final String HIDDEN_SUFFIX = "_Hidden";
    public static final String SERVER_SUFFIX = "_Server";
    public static final String taskFieldArrayCategory = "taskSpreadsheet";
    public static final String resourceFieldArrayCategory = "resourceSpreadsheet";
    public static final String portfolioFieldArrayCategory = "portfolioSpreadsheet";
    public static final String projectFieldArrayCategory = "projectSpreadsheet";
    public static final String projectFieldArrayCategoryHidden = "projectSpreadsheet_Hidden";
    public static final String timesheetFieldArrayCategory = "timesheetSpreadsheet";

    public static SpreadSheetFieldArray removeNonWebFields(SpreadSheetFieldArray spreadSheetFieldArray) {
        SpreadSheetFieldArray spreadSheetFieldArray2 = (SpreadSheetFieldArray)spreadSheetFieldArray.clone();
        Iterator iterator = spreadSheetFieldArray2.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.getId().equals("Field.indicators") && (!projectFieldArrayCategory.equals(spreadSheetFieldArray2.getCategory()) || !"Field.id".equals(field.getId()))) continue;
            iterator.remove();
        }
        return spreadSheetFieldArray2;
    }

    public static SpreadSheetFieldArray getFieldArray(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = FieldArrayUtil.typetoCategory(n);
        Object object = FieldArrayUtil.getFromId(string2, string);
        if (object == null) {
            object = FieldArrayUtil.getFromId(string2 + SERVER_SUFFIX, string);
        }
        if (object == null) {
            return null;
        }
        return FieldArrayUtil.removeNonWebFields((SpreadSheetFieldArray)object);
    }

    public static SpreadSheetFieldArray getHiddenFieldArray(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = FieldArrayUtil.typetoHiddenCategory(n);
        Object object = FieldArrayUtil.getFromId(string2, string);
        if (object == null) {
            return null;
        }
        return FieldArrayUtil.removeNonWebFields((SpreadSheetFieldArray)object);
    }

    public static String typetoCategory(int n) {
        if (n == 1) {
            return taskFieldArrayCategory;
        }
        if (n == 2) {
            return resourceFieldArrayCategory;
        }
        if (n == 3) {
            return projectFieldArrayCategory;
        }
        if (n == 4) {
            return timesheetFieldArrayCategory;
        }
        return null;
    }

    public static String typetoHiddenCategory(int n) {
        if (n == 3) {
            return projectFieldArrayCategoryHidden;
        }
        return null;
    }

    private static final Object getFromId(String string, String string2) {
        NamedItem namedItem = Dictionary.get(string, Messages.getString(string2));
        if (namedItem == null) {
            namedItem = Dictionary.get(string, string2);
        }
        return namedItem;
    }
}

