/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.configuration.Configuration;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.datatype.Duration;
import com.projity.datatype.Rate;
import com.projity.exchange.ImportedCalendarService;
import com.projity.field.CustomFields;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkDay;
import com.projity.pm.calendar.WorkRange;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.calendar.WorkingHours;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.server.data.CustomFieldsMapper;
import com.projity.util.DateTime;
import com.projity.util.MathUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.mspdi.DatatypeConverter;

public class MPXConverter {
    private static Log log = LogFactory.getLog(MPXConverter.class);
    public static int nameFieldWidth = Configuration.getFieldFromId("Field.name").getTextWidth();
    private static int autoId = 0;

    public static void toMPXOptions(ProjectProperties projectProperties) {
        CalendarOption calendarOption = CalendarOption.getInstance();
        projectProperties.setMinutesPerDay(new Integer((int)(60.0 * calendarOption.getHoursPerDay())));
        projectProperties.setMinutesPerWeek(new Integer((int)(60.0 * calendarOption.getHoursPerWeek())));
        projectProperties.setDaysPerMonth(new Integer((int)Math.round(calendarOption.getDaysPerMonth())));
        projectProperties.setDefaultStartTime(calendarOption.getDefaultStartTime().getTime());
        projectProperties.setDefaultEndTime(calendarOption.getDefaultEndTime().getTime());
    }

    public static void toMPXProject(Project project, ProjectProperties projectProperties) {
        WorkCalendar workCalendar = project.getBaseCalendar();
        projectProperties.setDefaultCalendarName(workCalendar.getName());
        projectProperties.setName(project.getName());
        projectProperties.setProjectTitle(project.getName());
        projectProperties.setComments(project.getNotes());
        projectProperties.setManager(project.getManager());
        projectProperties.setComments(MPXConverter.removeInvalidChars(project.getNotes()));
        projectProperties.setStartDate(DateTime.fromGmt(new Date(project.getStartDate())));
        projectProperties.setFinishDate(DateTime.fromGmt(new Date(project.getFinishDate())));
        projectProperties.setDefaultStartTime(CalendarOption.getInstance().getDefaultStartTime().getTime());
        projectProperties.setDefaultEndTime(CalendarOption.getInstance().getDefaultEndTime().getTime());
    }

    public static void toMpxCalendar(WorkingCalendar workingCalendar, ProjectCalendar projectCalendar) {
        Object object;
        Object object2;
        projectCalendar.setName(workingCalendar.getName());
        WorkingCalendar workingCalendar2 = workingCalendar;
        if (workingCalendar.isBaseCalendar()) {
            workingCalendar2 = (WorkingCalendar)workingCalendar.getBaseCalendar();
        }
        for (int i = 0; i < 7; ++i) {
            WorkDay workDay = workingCalendar.isBaseCalendar() ? workingCalendar.getDerivedWeekDay(i) : workingCalendar.getWeekDay(i);
            object2 = null;
            object = Day.getInstance(i + 1);
            if (workDay == null) {
                projectCalendar.setWorkingDay((Day)object, DayType.DEFAULT);
                continue;
            }
            projectCalendar.setWorkingDay((Day)object, workDay.isWorking());
            if (!workDay.isWorking()) continue;
            object2 = projectCalendar.addCalendarHours(Day.getInstance(i + 1));
            MPXConverter.toMpxCalendarDay(workDay, (ProjectCalendarHours)object2);
        }
        WorkDay[] workDayArray = workingCalendar.getExceptionDays();
        if (workDayArray != null) {
            for (int i = 0; i < workDayArray.length; ++i) {
                if (workDayArray[i] == null || workDayArray[i].getStart() == 0L || workDayArray[i].getStart() == Long.MAX_VALUE) continue;
                object2 = new Date(workDayArray[i].getStart());
                object = DateTime.calendarInstance();
                ((Calendar)object).setTime((Date)object2);
                ((Calendar)object).set(10, 23);
                ((Calendar)object).set(12, 59);
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException((Date)object2, DateTime.fromGmt(((Calendar)object).getTime()));
                MPXConverter.toMpxExceptionDay(workDayArray[i], projectCalendarException);
            }
        }
        if (!workingCalendar.isBaseCalendar()) {
            WorkCalendar workCalendar = workingCalendar.getBaseCalendar();
            projectCalendar.setParent(ImportedCalendarService.getInstance().findExportedCalendar(workCalendar));
        }
    }

    public static void toMpxCalendarDay(WorkDay workDay, ProjectCalendarHours projectCalendarHours) {
        if (workDay == null) {
            return;
        }
        WorkingHours workingHours = workDay.getWorkingHours();
        for (WorkRange workRange : workingHours.getIntervals()) {
            if (workRange == null) continue;
            projectCalendarHours.addRange(new DateRange(DateTime.fromGmt(workRange.getNormalizedStartTime()), DateTime.fromGmt(workRange.getNormalizedEndTime())));
        }
    }

    public static void toMpxExceptionDay(WorkDay workDay, ProjectCalendarException projectCalendarException) {
        if (workDay == null) {
            return;
        }
        WorkingHours workingHours = workDay.getWorkingHours();
        WorkRange workRange = workingHours.getInterval(0);
        if (workRange != null) {
            projectCalendarException.addRange(new DateRange(DateTime.fromGmt(workRange.getNormalizedStartTime()), DateTime.fromGmt(workRange.getNormalizedEndTime())));
        }
        if ((workRange = workingHours.getInterval(1)) != null) {
            projectCalendarException.addRange(new DateRange(DateTime.fromGmt(workRange.getNormalizedStartTime()), DateTime.fromGmt(workRange.getNormalizedEndTime())));
        }
        if ((workRange = workingHours.getInterval(2)) != null) {
            projectCalendarException.addRange(new DateRange(DateTime.fromGmt(workRange.getNormalizedStartTime()), DateTime.fromGmt(workRange.getNormalizedEndTime())));
        }
    }

    public static void toMPXResource(ResourceImpl resourceImpl, Resource resource) {
        resource.setName(MPXConverter.removeInvalidChars(resourceImpl.getName()));
        resource.setNotes(MPXConverter.removeInvalidChars(resourceImpl.getNotes()));
        resource.setAccrueAt(AccrueType.getInstance(resourceImpl.getAccrueAt()));
        resource.setCostPerUse(new Double(resourceImpl.getCostPerUse()));
        resource.setStandardRate(MPXConverter.toMPXRate(resourceImpl.getStandardRate()));
        resource.setOvertimeRate(MPXConverter.toMPXRate(resourceImpl.getOvertimeRate()));
        resource.setGroup(resourceImpl.getGroup());
        resource.setEmailAddress(resourceImpl.getEmailAddress());
        resource.setIsGeneric(resourceImpl.isGeneric());
        resource.setInitials(resourceImpl.getInitials());
        resource.setID((int)resourceImpl.getId());
        long l = resourceImpl.getExternalId();
        if (l <= 0L) {
            l = resourceImpl.getId();
        }
        resource.setUniqueID((int)l);
        resource.setMaxUnits(resourceImpl.getMaximumUnits() * 100.0);
        WorkingCalendar workingCalendar = (WorkingCalendar)resourceImpl.getWorkCalendar();
        if (workingCalendar != null) {
            ProjectCalendar projectCalendar = null;
            try {
                projectCalendar = resource.addResourceCalendar();
            }
            catch (MPXJException mPXJException) {
                mPXJException.printStackTrace();
                return;
            }
            MPXConverter.toMpxCalendar(workingCalendar, projectCalendar);
        }
        MPXConverter.toMpxCustomFields(resourceImpl.getCustomFields(), resource, CustomFieldsMapper.getInstance().resourceMaps);
    }

    public static void toMpxCustomFields(CustomFields customFields, FieldContainer fieldContainer, CustomFieldsMapper.Maps maps) {
        int n;
        for (n = 0; n < maps.costMap.length; ++n) {
            double d = customFields.getCustomCost(n);
            if (d == 0.0) continue;
            fieldContainer.set(maps.costMap[n], new Double(d));
        }
        for (n = 0; n < maps.dateMap.length; ++n) {
            long l = customFields.getCustomDate(n);
            if (l == 0L) continue;
            fieldContainer.set(maps.dateMap[n], new Date(l));
        }
        for (n = 0; n < maps.durationMap.length; ++n) {
            long l = customFields.getCustomDuration(n);
            if (Duration.millis(l) == 0L) continue;
            fieldContainer.set(maps.durationMap[n], MPXConverter.toMPXDuration(l));
        }
        for (n = 0; n < maps.finishMap.length; ++n) {
            long l = customFields.getCustomFinish(n);
            if (l == 0L) continue;
            fieldContainer.set(maps.finishMap[n], new Date(l));
        }
        for (n = 0; n < maps.flagMap.length; ++n) {
            boolean bl = customFields.getCustomFlag(n);
            if (!bl) continue;
            fieldContainer.set(maps.flagMap[n], Boolean.TRUE);
        }
        for (n = 0; n < maps.numberMap.length; ++n) {
            double d = customFields.getCustomNumber(n);
            if (d == 0.0) continue;
            fieldContainer.set(maps.numberMap[n], new Double(d));
        }
        for (n = 0; n < maps.startMap.length; ++n) {
            long l = customFields.getCustomStart(n);
            if (l == 0L) continue;
            fieldContainer.set(maps.startMap[n], new Date(l));
        }
        for (n = 0; n < maps.textMap.length; ++n) {
            String string = customFields.getCustomText(n);
            if (string == null) continue;
            fieldContainer.set(maps.textMap[n], MPXConverter.removeInvalidChars(string));
        }
    }

    public static void toMPXAssignment(Assignment assignment, ResourceAssignment resourceAssignment) {
        long l;
        long l2 = assignment.getWork(null);
        resourceAssignment.setWork(MPXConverter.toMPXDuration(l2));
        resourceAssignment.setUnits(MathUtils.roundToDecentPrecision(assignment.getUnits() * 100.0));
        resourceAssignment.setRemainingWork(MPXConverter.toMPXDuration(assignment.getRemainingWork()));
        long l3 = Duration.millis(assignment.getDelay());
        if (l3 != 0L) {
            CalendarOption calendarOption = CalendarOption.getInstance();
            CalendarOption.setInstance(CalendarOption.getDefaultInstance());
            resourceAssignment.setDelay(MPXConverter.toMPXDuration(assignment.getDelay()));
            CalendarOption.setInstance(calendarOption);
        }
        if ((l = Duration.millis(assignment.getLevelingDelay())) != 0L) {
            CalendarOption calendarOption = CalendarOption.getInstance();
            CalendarOption.setInstance(CalendarOption.getDefaultInstance());
            resourceAssignment.setDelay(MPXConverter.toMPXDuration(assignment.getLevelingDelay()));
            CalendarOption.setInstance(calendarOption);
        }
        resourceAssignment.setWorkContour(WorkContour.getInstance(assignment.getWorkContourType()));
    }

    public static String removeInvalidChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\r' && c != '\n' && c != '\t') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }

    public static void toMPXTask(NormalTask normalTask, Task task) {
        WorkCalendar workCalendar;
        task.setName(MPXConverter.removeInvalidChars(normalTask.getName()));
        if (normalTask.getWbs() != null) {
            task.setWBS(MPXConverter.removeInvalidChars(normalTask.getWbs()));
        }
        task.setNotes(MPXConverter.removeInvalidChars(normalTask.getNotes()));
        task.setID((int)normalTask.getId());
        task.setUniqueID((int)normalTask.getId());
        task.setCreateDate(normalTask.getCreated());
        task.setDuration(MPXConverter.toMPXDuration(normalTask.getDuration()));
        task.setStart(DateTime.fromGmt(new Date(normalTask.getStart())));
        task.setFinish(DateTime.fromGmt(new Date(normalTask.getEnd())));
        task.setCritical(new Boolean(normalTask.isCritical()));
        task.setEstimated(normalTask.isEstimated());
        task.setEffortDriven(normalTask.isEffortDriven());
        task.setType(TaskType.getInstance(normalTask.getSchedulingType()));
        task.setConstraintType(ConstraintType.getInstance(normalTask.getConstraintType()));
        task.setConstraintDate(DateTime.fromGmt(new Date(normalTask.getConstraintDate())));
        task.setPriority(Priority.getInstance(normalTask.getPriority()));
        task.setFixedCost(normalTask.getFixedCost());
        task.setFixedCostAccrual(AccrueType.getInstance(normalTask.getFixedCostAccrual()));
        task.setMilestone(normalTask.isMarkTaskAsMilestone());
        task.setLevelingDelay(MPXConverter.toMPXDuration(normalTask.getLevelingDelay()));
        if (normalTask.getDeadline() != 0L) {
            task.setDeadline(DateTime.fromGmt(new Date(normalTask.getDeadline())));
        }
        task.setEarnedValueMethod(EarnedValueMethod.getInstance(normalTask.getEarnedValueMethod()));
        task.setIgnoreResourceCalendar(normalTask.isIgnoreResourceCalendar());
        task.setTotalSlack(MPXConverter.toMPXDuration(normalTask.getTotalSlack()));
        task.setRemainingDuration(MPXConverter.toMPXDuration(normalTask.getRemainingDuration()));
        if (normalTask.getStop() != 0L) {
            task.setStop(DateTime.fromGmt(new Date(normalTask.getStop())));
        }
        if ((workCalendar = normalTask.getWorkCalendar()) != null) {
            task.setCalendar(ImportedCalendarService.getInstance().findExportedCalendar(workCalendar));
        }
        MPXConverter.toMpxCustomFields(normalTask.getCustomFields(), task, CustomFieldsMapper.getInstance().taskMaps);
    }

    public static void toMPXVoid(VoidNodeImpl voidNodeImpl, Task task) {
        task.setID((int)voidNodeImpl.getId());
        task.setUniqueID((int)voidNodeImpl.getId());
        task.setNull(true);
        task.setCritical(false);
        task.setTotalSlack(MPXConverter.toMPXDuration(0L));
    }

    public static net.sf.mpxj.Rate toMPXRate(Rate rate) {
        double d = rate.getValue() * Duration.timeUnitFactor(rate.getTimeUnit());
        return new net.sf.mpxj.Rate(d, TimeUnit.getInstance(rate.getTimeUnit()));
    }

    public static net.sf.mpxj.Duration toMPXDuration(long l) {
        return net.sf.mpxj.Duration.getInstance(Duration.getValue(l), TimeUnit.getInstance(Duration.getType(l)));
    }

    public static final String dateToXMLString(long l) {
        Calendar calendar = DatatypeConverter.printDate(new Date(l));
        String string = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(calendar.getTime());
        String string2 = new SimpleDateFormat("Z").format(calendar.getTime());
        string = string + string2.substring(0, 3) + ":" + string2.substring(3);
        return string;
    }

    private static String truncName(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > nameFieldWidth) {
            string = string.substring(0, nameFieldWidth);
        }
        return string;
    }
}

