/*
 * Decompiled with CFR 0.152.
 */
package com.projity.timescale;

import com.projity.pm.time.HasStartAndEnd;
import com.projity.timescale.CalendarUtil;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeScale;
import com.projity.util.DateTime;
import java.util.Calendar;

public class TimeIterator
implements HasStartAndEnd {
    protected long startTime;
    protected long endTime;
    protected Calendar calendar1;
    protected Calendar calendar2;
    protected TimeScale scale;
    private boolean hasNext = true;
    private long next2 = -1L;
    private boolean useLargeScale;

    public TimeIterator(long l, long l2, TimeScale timeScale, long l3) {
        this(l, l2, timeScale, l3, false);
    }

    public TimeIterator(long l, long l2, TimeScale timeScale, long l3, boolean bl) {
        long l4;
        long l5;
        this.useLargeScale = bl;
        if (l <= l2) {
            l5 = l;
            l4 = l2;
        } else {
            l4 = l;
            l5 = l2;
        }
        long l6 = l3;
        this.startTime = l5;
        this.endTime = l5 == l4 ? l4 + 1L : l4;
        this.scale = timeScale;
        if (bl) {
            this.calendar2 = DateTime.calendarInstance();
            this.calendar2 = DateTime.calendarInstance();
            this.calendar2.setTimeInMillis(l5);
            if (l6 == -1L) {
                timeScale.floor2(this.calendar2);
            } else {
                timeScale.floor2(this.calendar2, l6);
            }
            this.startTime = this.calendar2.getTimeInMillis();
        } else {
            this.calendar1 = DateTime.calendarInstance();
            this.calendar1 = DateTime.calendarInstance();
            this.calendar1.setTimeInMillis(l5);
            if (l6 == -1L) {
                timeScale.floor1(this.calendar1);
            } else {
                timeScale.floor1(this.calendar1, l6);
            }
            this.calendar2 = DateTime.calendarInstance();
            this.calendar2.setTimeInMillis(l5);
            timeScale.floor2(this.calendar2, l6);
            this.startTime = this.calendar1.getTimeInMillis();
        }
    }

    public TimeIterator(double d, double d2, TimeScale timeScale, long l) {
        this(d, d2, timeScale, l, false);
    }

    public TimeIterator(double d, double d2, TimeScale timeScale, long l, boolean bl) {
        this(CalendarUtil.toLongTime(d), CalendarUtil.toLongTime(d2), timeScale, l, bl);
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public TimeInterval next() {
        if (!this.hasNext) {
            return null;
        }
        if (this.useLargeScale) {
            long l = this.calendar2.getTimeInMillis();
            this.scale.increment2(this.calendar2);
            long l2 = this.calendar2.getTimeInMillis();
            if (l2 >= this.endTime) {
                this.hasNext = false;
            }
            String string = this.scale.getText2(l);
            return new TimeInterval(l, l2, string, -1L, -1L, null);
        }
        long l = this.calendar1.getTimeInMillis();
        this.scale.increment1(this.calendar1);
        long l3 = this.calendar1.getTimeInMillis();
        if (l3 >= this.endTime) {
            this.hasNext = false;
        }
        String string = this.scale.getText1(l);
        long l4 = -1L;
        long l5 = -1L;
        String string2 = null;
        if (this.next2 == -1L || l >= this.next2) {
            l4 = this.calendar2.getTimeInMillis();
            this.scale.increment2(this.calendar2);
            this.next2 = l5 = this.calendar2.getTimeInMillis();
            string2 = this.scale.getText2(l4);
        }
        return new TimeInterval(l, l3, string, l4, l5, string2);
    }

    public long getEnd() {
        return this.endTime;
    }

    public long getStart() {
        return this.startTime;
    }
}

