/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FilterContainer;
import net.sf.mpxj.GroupContainer;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarContainer;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentContainer;
import net.sf.mpxj.ResourceContainer;
import net.sf.mpxj.SubProjectContainer;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.ViewContainer;
import net.sf.mpxj.common.NumberHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFile
implements ChildTaskContainer {
    private final ProjectConfig m_config = new ProjectConfig(this);
    private final ProjectProperties m_properties = new ProjectProperties(this);
    private final ResourceContainer m_resources = new ResourceContainer(this);
    private final TaskContainer m_tasks = new TaskContainer(this);
    private final List<Task> m_childTasks = new LinkedList<Task>();
    private final ResourceAssignmentContainer m_assignments = new ResourceAssignmentContainer(this);
    private final ProjectCalendarContainer m_calendars = new ProjectCalendarContainer(this);
    private final TableContainer m_tables = new TableContainer();
    private final FilterContainer m_filters = new FilterContainer();
    private final GroupContainer m_groups = new GroupContainer();
    private final SubProjectContainer m_subProjects = new SubProjectContainer();
    private final ViewContainer m_views = new ViewContainer();
    private final EventManager m_eventManager = new EventManager();
    private final CustomFieldContainer m_customFields = new CustomFieldContainer();

    public ProjectConfig getProjectConfig() {
        return this.m_config;
    }

    public Task addTask() {
        return this.m_tasks.add();
    }

    public void removeTask(Task task) {
        this.m_tasks.remove(task);
    }

    public void renumberTaskIDs() {
        this.m_tasks.renumberIDs();
    }

    public void renumberResourceIDs() {
        this.m_resources.renumberIDs();
    }

    public void validateUniqueIDsForMicrosoftProject() {
        this.m_tasks.validateUniqueIDsForMicrosoftProject();
        this.m_resources.validateUniqueIDsForMicrosoftProject();
        this.m_assignments.validateUniqueIDsForMicrosoftProject();
        this.m_calendars.validateUniqueIDsForMicrosoftProject();
    }

    public void synchronizeTaskIDToHierarchy() {
        this.m_tasks.synchronizeTaskIDToHierarchy();
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_childTasks;
    }

    public TaskContainer getAllTasks() {
        return this.m_tasks;
    }

    public ProjectCalendar addCalendar() {
        return this.m_calendars.add();
    }

    public void removeCalendar(ProjectCalendar projectCalendar) {
        this.m_calendars.remove(projectCalendar);
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        return this.m_calendars.addDefaultBaseCalendar();
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        return this.m_calendars.addDefaultDerivedCalendar();
    }

    public ProjectCalendarContainer getCalendars() {
        return this.m_calendars;
    }

    public ProjectProperties getProjectProperties() {
        return this.m_properties;
    }

    public Resource addResource() {
        return this.m_resources.add();
    }

    public void removeResource(Resource resource) {
        this.m_resources.remove(resource);
    }

    public ResourceContainer getAllResources() {
        return this.m_resources;
    }

    public ResourceAssignmentContainer getAllResourceAssignments() {
        return this.m_assignments;
    }

    public ResourceAssignment newResourceAssignment(Task task) {
        return new ResourceAssignment(this, task);
    }

    public ProjectCalendar getCalendarByName(String string) {
        return this.m_calendars.getByName(string);
    }

    public ProjectCalendar getCalendarByUniqueID(Integer n) {
        return (ProjectCalendar)this.m_calendars.getByUniqueID(n);
    }

    public Duration getDuration(Date date, Date date2) throws MPXJException {
        return this.getDuration("Standard", date, date2);
    }

    public Duration getDuration(String string, Date date, Date date2) throws MPXJException {
        ProjectCalendar projectCalendar = this.getCalendarByName(string);
        if (projectCalendar == null) {
            throw new MPXJException("Invalid calendar: " + string);
        }
        return projectCalendar.getDuration(date, date2);
    }

    public Task getTaskByID(Integer n) {
        return (Task)this.m_tasks.getByID(n);
    }

    public Task getTaskByUniqueID(Integer n) {
        return (Task)this.m_tasks.getByUniqueID(n);
    }

    public Resource getResourceByID(Integer n) {
        return (Resource)this.m_resources.getByID(n);
    }

    public Resource getResourceByUniqueID(Integer n) {
        return (Resource)this.m_resources.getByUniqueID(n);
    }

    public void updateStructure() {
        this.m_tasks.updateStructure();
    }

    public Date getStartDate() {
        Date date = null;
        for (Task task : this.m_tasks) {
            Date date2;
            if (NumberHelper.getInt(task.getUniqueID()) == 0) continue;
            if (task.getMilestone()) {
                date2 = task.getActualFinish();
                if (date2 == null) {
                    date2 = task.getFinish();
                }
            } else {
                date2 = task.getActualStart();
                if (date2 == null) {
                    date2 = task.getStart();
                }
            }
            if (date2 == null) continue;
            if (date == null) {
                date = date2;
                continue;
            }
            if (date2.getTime() >= date.getTime()) continue;
            date = date2;
        }
        return date;
    }

    public Date getFinishDate() {
        Date date = null;
        for (Task task : this.m_tasks) {
            if (NumberHelper.getInt(task.getUniqueID()) == 0) continue;
            Date date2 = task.getActualFinish();
            if (date2 == null) {
                date2 = task.getFinish();
            }
            if (date2 == null) continue;
            if (date == null) {
                date = date2;
                continue;
            }
            if (date2.getTime() <= date.getTime()) continue;
            date = date2;
        }
        return date;
    }

    public ViewContainer getViews() {
        return this.m_views;
    }

    public TableContainer getTables() {
        return this.m_tables;
    }

    public FilterContainer getFilters() {
        return this.m_filters;
    }

    public GroupContainer getGroups() {
        return this.m_groups;
    }

    public SubProjectContainer getSubProjects() {
        return this.m_subProjects;
    }

    public EventManager getEventManager() {
        return this.m_eventManager;
    }

    public CustomFieldContainer getCustomFields() {
        return this.m_customFields;
    }

    public ProjectCalendar getDefaultCalendar() {
        String string = this.m_properties.getDefaultCalendarName();
        ProjectCalendar projectCalendar = this.getCalendarByName(string);
        if (projectCalendar == null) {
            projectCalendar = this.m_calendars.isEmpty() ? this.addDefaultBaseCalendar() : (ProjectCalendar)this.m_calendars.get(0);
        }
        return projectCalendar;
    }

    public void setDefaultCalendar(ProjectCalendar projectCalendar) {
        this.m_properties.setDefaultCalendarName(projectCalendar.getName());
    }

    public ProjectCalendar getBaselineCalendar() {
        ProjectCalendar projectCalendar = this.getCalendarByName("Used for Microsoft Project 98 Baseline Calendar");
        if (projectCalendar == null) {
            projectCalendar = this.getDefaultCalendar();
        }
        return projectCalendar;
    }
}

