/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.Record;

final class ResourceModel {
    private ProjectFile m_parentFile;
    private boolean[] m_flags = new boolean[52];
    private int[] m_fields = new int[53];
    private int m_count;
    private String[] m_resourceNames;
    private HashMap<String, Integer> m_resourceNumbers = new HashMap();

    ResourceModel(ProjectFile projectFile, Locale locale) {
        this.m_parentFile = projectFile;
        this.setLocale(locale);
    }

    void setLocale(Locale locale) {
        this.m_resourceNames = LocaleData.getStringArray(locale, "RESOURCE_NAMES");
        this.m_resourceNumbers.clear();
        for (int i = 0; i < this.m_resourceNames.length; ++i) {
            String string = this.m_resourceNames[i];
            if (string == null) continue;
            this.m_resourceNumbers.put(string, i);
        }
    }

    public void update(Record record, boolean bl) throws MPXJException {
        int n = record.getLength();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                this.add(this.getResourceCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    private void populateModel() {
        if (this.m_count != 0) {
            this.m_count = 0;
            Arrays.fill(this.m_flags, false);
        }
        for (Resource resource : this.m_parentFile.getAllResources()) {
            for (int i = 0; i < 52; ++i) {
                if (resource.getCachedValue(MPXResourceField.getMpxjField(i)) == null || this.m_flags[i]) continue;
                this.m_flags[i] = true;
                this.m_fields[this.m_count] = i;
                ++this.m_count;
            }
        }
        Arrays.sort(this.m_fields);
        System.arraycopy(this.m_fields, this.m_fields.length - this.m_count, this.m_fields, 0, this.m_count);
    }

    public String toString() {
        this.populateModel();
        char c = this.m_parentFile.getProjectProperties().getMpxDelimiter();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append(40);
        stringBuilder2.append(41);
        for (int i = 0; i < this.m_count; ++i) {
            int n = this.m_fields[i];
            stringBuilder.append(c);
            stringBuilder2.append(c);
            stringBuilder.append(this.getResourceField(n));
            stringBuilder2.append(n);
        }
        stringBuilder.append("\r\n");
        stringBuilder2.append("\r\n");
        stringBuilder.append(stringBuilder2.toString());
        return stringBuilder.toString();
    }

    private void add(int n) {
        if (n < this.m_flags.length && !this.m_flags[n]) {
            this.m_flags[n] = true;
            this.m_fields[this.m_count] = n;
            ++this.m_count;
        }
    }

    private String getResourceField(int n) {
        String string = null;
        if (n > 0 && n < this.m_resourceNames.length) {
            string = this.m_resourceNames[n];
        }
        return string;
    }

    private int getResourceCode(String string) throws MPXJException {
        Integer n = this.m_resourceNumbers.get(string);
        if (n == null) {
            throw new MPXJException("Invalid resource field name " + string);
        }
        return n;
    }
}

