/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.server.api;

import com.pomodorotechnique.server.InterruptionType;
import com.pomodorotechnique.server.Messages;
import com.pomodorotechnique.server.PlanType;
import com.pomodorotechnique.server.Plans;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.UserType;
import com.pomodorotechnique.server.Users;
import com.pomodorotechnique.server.WorkitemType;
import com.pomodorotechnique.server.api.AlreadyExistsException;
import com.pomodorotechnique.server.api.InvalidStateException;
import com.pomodorotechnique.server.api.NoPomodorosLeftException;
import com.pomodorotechnique.server.api.NotFoundException;
import java.util.Calendar;

public interface Server {
    public Users getAllUsers();

    public UserType getUser();

    public PomodoroType addPomodoro(WorkitemType var1) throws NotFoundException;

    public void voidPomodoro(WorkitemType var1) throws InvalidStateException;

    public void completePomodoro(WorkitemType var1) throws InvalidStateException;

    public PomodoroType startNextPomodoro(WorkitemType var1) throws NotFoundException, NoPomodorosLeftException;

    public WorkitemType addWorkItem(String var1, int var2) throws NotFoundException;

    public void completeWorkItem(WorkitemType var1);

    public Plans getPlans();

    public PlanType createPlan() throws AlreadyExistsException;

    public PlanType getPlan(Calendar var1) throws NotFoundException;

    public PlanType getPlan() throws NotFoundException;

    public void registerInterruption(WorkitemType var1, InterruptionType var2) throws InvalidStateException;

    public void sendMessage(String var1, String var2) throws InvalidStateException;

    public Messages getMessages(WorkitemType var1) throws InvalidStateException;

    public void logout();

    public void deletePlan(PlanType var1);
}

