/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS.rawData;

import FCSalyzer.FCS.rawData.FCS_data_metainfo;
import FCSalyzer.FCS.rawData.FCS_parameter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import staticStuff.staticMethods;

public abstract class FCS_datafile {
    protected FCS_data_metainfo metaInfo;
    private MappedByteBuffer bytes = null;
    private static final Object sync_access = new Object();
    protected static final int lower8bitMask = 255;

    private FCS_datafile() {
    }

    protected FCS_datafile(FCS_data_metainfo toOpen) {
        this.metaInfo = toOpen;
        this.bytes = this.metaInfo.bytes;
        if (this.bytes != null) {
            double[][] firstEventData = this.getEvents(0, 1);
            double[][] lastEventData = null;
            lastEventData = this.getEvents(this.metaInfo.eventCount - 1, 1);
            for (int i = 0; i < this.metaInfo.parameters.length; ++i) {
                FCS_parameter currParam = this.metaInfo.parameters[i];
                if (currParam.get$PnN_name().toLowerCase().equals("time") || currParam.get$PnN_name().toLowerCase().equals("event #") || currParam.get$PnS_description().toLowerCase().equals("time") || currParam.get$PnS_description().toLowerCase().equals("event #")) {
                    currParam.setRange(lastEventData[0][i] + 1.0);
                }
                if ((long)((int)lastEventData[0][i] + 1) >= currParam.get$PnR_range()) {
                    currParam.setRange((int)lastEventData[0][i] + 1);
                }
                if ((long)((int)firstEventData[0][i] + 1) < currParam.get$PnR_range()) continue;
                currParam.setRange((int)firstEventData[0][i] + 1);
            }
        }
    }

    abstract int[] rearrangeEventData(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getEvents(int index, int count) {
        int location = index * this.metaInfo.byteCount + this.metaInfo.startDATA;
        int bytesNeeded = this.metaInfo.byteCount * count;
        byte[] byt = new byte[bytesNeeded];
        Object object = sync_access;
        synchronized (object) {
            this.bytes.position(location);
            this.bytes.get(byt);
        }
        double[][] toReturn = new double[count][];
        for (int i = 0; i < count; ++i) {
            int j;
            byte[] eventByt = new byte[this.metaInfo.byteCount];
            int off = i * this.metaInfo.byteCount;
            for (int m = 0; m < this.metaInfo.byteCount; ++m) {
                eventByt[m] = byt[off + m];
            }
            int[] arranged = this.rearrangeEventData(eventByt);
            double[] returnData = new double[arranged.length];
            if (this.metaInfo.isFloat) {
                for (j = 0; j < returnData.length; ++j) {
                    returnData[j] = Float.intBitsToFloat(arranged[j]);
                }
            } else {
                for (j = 0; j < returnData.length; ++j) {
                    returnData[j] = arranged[j];
                }
            }
            toReturn[i] = returnData;
        }
        return toReturn;
    }

    public int getEventCount() {
        return this.metaInfo.eventCount;
    }

    public long getRange(int parameter) {
        return this.metaInfo.parameters[parameter].get$PnR_range();
    }

    public String getFileName() {
        String returnText;
        int index = this.metaInfo.KeywordsTEXT.indexOf("$FIL");
        if (index > -1 && (returnText = this.metaInfo.ValuesTEXT.get(this.metaInfo.KeywordsTEXT.indexOf("$FIL"))) != null) {
            return returnText;
        }
        return this.getDataFileName();
    }

    public String getParameterName(int index) {
        return this.metaInfo.parameters[index].get$PnN_name();
    }

    public String getParameterDesc(int index) {
        return this.metaInfo.parameters[index].get$PnS_description();
    }

    public String[] getParameterLabels() {
        return this.metaInfo.parameterLabels;
    }

    public String getParameterLabel(int index) {
        return this.metaInfo.parameterLabels[index];
    }

    public float getLogDecades(int index) {
        return this.metaInfo.parameters[index].getDecades();
    }

    public float getOffset(int index) {
        return this.metaInfo.parameters[index].getOffset();
    }

    public int getParameterCount() {
        return this.metaInfo.parameters.length;
    }

    public String getDataFileName() {
        return this.metaInfo.FileName;
    }

    public String getDataFilePath() {
        return this.metaInfo.FilePath;
    }

    public ArrayList<String> getKeywordsDescription() {
        return this.metaInfo.KeywordsDescription;
    }

    public ArrayList<String> getKeywordsTEXT() {
        return this.metaInfo.KeywordsTEXT;
    }

    public ArrayList<String> getValuesTEXT() {
        return this.metaInfo.ValuesTEXT;
    }

    public String getValueTEXT(int index) {
        if (index < 0 || index >= this.metaInfo.ValuesTEXT.size()) {
            return "";
        }
        return this.metaInfo.ValuesTEXT.get(index);
    }

    public String getValueTEXT(String annotationKeyword) {
        int index = this.metaInfo.KeywordsTEXT.indexOf(annotationKeyword);
        if (index == -1) {
            index = this.metaInfo.KeywordsTEXT.indexOf(annotationKeyword.toLowerCase());
        }
        if (index > -1 && index < this.metaInfo.KeywordsTEXT.size()) {
            return this.metaInfo.ValuesTEXT.get(index);
        }
        return "";
    }

    public String getSampleDescription() {
        String toReturn = this.getValueTEXT("SAMPLE ID");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("TUBE NAME");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("$SRC");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("$SMNO");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        return this.getFileName();
    }

    public boolean isFloatData() {
        return this.metaInfo.isFloat;
    }

    public boolean parameterIsStoredAsLog(int param) {
        if (this.metaInfo.isFloat) {
            return false;
        }
        return this.metaInfo.parameters[param].hasLogScale();
    }

    public boolean displayParamAsLog(int param) {
        return this.metaInfo.parameters[param].displayOnLog();
    }

    public long parameterRange(int parameter) {
        return this.metaInfo.parameters[parameter].get$PnR_range();
    }

    public boolean hasSpillover() {
        return this.metaInfo.spilloverValues != null;
    }

    public int[][] getSpillover() {
        int[][] toReturn = new int[this.metaInfo.spilloverValues.length][this.metaInfo.spilloverValues[0].length];
        for (int i = 0; i < toReturn.length; ++i) {
            for (int j = 0; j < toReturn[0].length; ++j) {
                toReturn[i][j] = this.metaInfo.spilloverValues[i][j];
            }
        }
        return toReturn;
    }

    public boolean isMQD() {
        return this.metaInfo.isMQD;
    }

    public synchronized void saveTo(BufferedOutputStream out) throws IOException {
        this.bytes.position(0);
        int toWrite = this.bytes.remaining();
        out.write(staticMethods.intAsBytes(toWrite));
        for (int i = 0; i < toWrite; ++i) {
            out.write(this.bytes.get());
        }
    }
}

