/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import java.awt.Color;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class colorGradient {
    public static int gradientSteps = 32;
    public String description = "";
    public int[] gradient;
    public int[] gradientMilestones;
    public static int[][] rainbowInt = new int[][]{{75, 0, 130}, {0, 0, 255}, {0, 255, 0}, {255, 255, 0}, {255, 127, 0}, {255, 0, 0}};
    public static final String XML_name = "Gradient";
    public static final String XML_desc = "Description";
    public static final String XML_color = "Colors";

    public colorGradient(String desc, Color start, Color end, int totalSteps) {
        this.description = desc;
        this.gradient = colorGradient.createGradient(start, end, totalSteps);
        this.gradientMilestones = new int[2];
        this.gradientMilestones[0] = start.getRGB();
        this.gradientMilestones[1] = end.getRGB();
    }

    public colorGradient(String desc, Color[] fixColors, int totalSteps) {
        this.description = desc;
        this.gradient = colorGradient.createGradient(fixColors, totalSteps);
        this.gradientMilestones = new int[fixColors.length];
        for (int i = 0; i < fixColors.length; ++i) {
            this.gradientMilestones[i] = fixColors[i].getRGB();
        }
    }

    public colorGradient(String desc, int[] fixColors, int totalSteps) {
        this.description = desc;
        this.gradient = colorGradient.createGradient(fixColors, totalSteps);
        this.gradientMilestones = new int[fixColors.length];
        for (int i = 0; i < fixColors.length; ++i) {
            this.gradientMilestones[i] = fixColors[i];
        }
    }

    public colorGradient(String desc, int[][] fixColors, int totalSteps) {
        this.description = desc;
        this.gradient = colorGradient.createGradient(fixColors, totalSteps);
        this.gradientMilestones = new int[fixColors.length];
        for (int i = 0; i < fixColors.length; ++i) {
            int[] toUse = new int[3];
            int[] current = fixColors[i];
            int max = 3;
            if (current.length < max) {
                max = current.length;
            }
            for (int j = 0; j < max; ++j) {
                toUse[j] = current[j];
            }
            this.gradientMilestones[i] = new Color(toUse[0], toUse[1], toUse[2]).getRGB();
        }
    }

    public static int[] createGradient(int[][] fixColors, int totalSteps) {
        Color[] fixC = new Color[fixColors.length];
        for (int i = 0; i < fixColors.length; ++i) {
            int[] current = fixColors[i];
            int[] toUse = new int[3];
            int max = 3;
            if (current.length < max) {
                max = current.length;
            }
            for (int j = 0; j < max; ++j) {
                toUse[j] = current[j];
            }
            fixC[i] = new Color(toUse[0], toUse[1], toUse[2]);
        }
        return colorGradient.createGradient(fixC, totalSteps);
    }

    public static int[] createGradient(int[] fixColors, int totalSteps) {
        Color[] fixC = new Color[fixColors.length];
        for (int i = 0; i < fixColors.length; ++i) {
            fixC[i] = new Color(fixColors[i]);
        }
        return colorGradient.createGradient(fixC, totalSteps);
    }

    public static int[] createGradient(Color[] fixColors, int totalSteps) {
        int[] colorGradient2 = new int[totalSteps];
        int steps = totalSteps / (fixColors.length - 1);
        int remainder = totalSteps % (fixColors.length - 1);
        int currentPart = 0;
        for (int i = 0; i < fixColors.length - 1; ++i) {
            int[] newGr = null;
            if (remainder > 0) {
                newGr = colorGradient.createGradient(fixColors[i], fixColors[i + 1], steps + 1);
                --remainder;
            } else {
                newGr = colorGradient.createGradient(fixColors[i], fixColors[i + 1], steps);
            }
            for (int m = 0; m < newGr.length; ++m) {
                colorGradient2[currentPart] = newGr[m];
                ++currentPart;
            }
        }
        return colorGradient2;
    }

    public static int[] createGradient(Color startColor, Color endColor, int gradientSteps) {
        int start = startColor.getRed();
        int end = endColor.getRed() + 1;
        int diff = end - start;
        float factor = (float)diff / (float)gradientSteps;
        int[] redGradient = new int[gradientSteps];
        for (int i = 0; i < gradientSteps; ++i) {
            redGradient[i] = start + (int)((float)i * factor) << 16;
        }
        start = startColor.getGreen();
        end = endColor.getGreen() + 1;
        diff = end - start;
        factor = (float)diff / (float)gradientSteps;
        int[] greenGradient = new int[gradientSteps];
        for (int i = 0; i < gradientSteps; ++i) {
            greenGradient[i] = start + (int)((float)i * factor) << 8;
        }
        start = startColor.getBlue();
        end = endColor.getBlue() + 1;
        diff = end - start;
        factor = (float)diff / (float)gradientSteps;
        int[] blueGradient = new int[gradientSteps];
        for (int i = 0; i < gradientSteps; ++i) {
            blueGradient[i] = start + (int)((float)i * factor);
        }
        int[] colorGradient2 = new int[gradientSteps];
        for (int i = 0; i < gradientSteps; ++i) {
            colorGradient2[i] = redGradient[i] + greenGradient[i] + blueGradient[i];
            colorGradient2[i] = colorGradient2[i] | 0xFF000000;
        }
        return colorGradient2;
    }

    public void setMilestone(int index, int newColor) {
        if (index < this.gradientMilestones.length) {
            this.gradientMilestones[index] = newColor;
        } else {
            int[] newG = new int[this.gradientMilestones.length + 1];
            for (int i = 0; i < this.gradientMilestones.length; ++i) {
                newG[i] = this.gradientMilestones[i];
            }
            newG[this.gradientMilestones.length] = newColor;
            this.gradientMilestones = newG;
        }
        this.gradient = colorGradient.createGradient(this.gradientMilestones, gradientSteps);
    }

    public void deleteMilestone(int index) {
        if (this.gradientMilestones.length == 2) {
            return;
        }
        if (index < this.gradientMilestones.length) {
            int i;
            int[] newG = new int[this.gradientMilestones.length - 1];
            for (i = 0; i < index; ++i) {
                newG[i] = this.gradientMilestones[i];
            }
            for (i = index + 1; i < this.gradientMilestones.length; ++i) {
                newG[i - 1] = this.gradientMilestones[i];
            }
            this.gradientMilestones = newG;
        }
        this.gradient = colorGradient.createGradient(this.gradientMilestones, gradientSteps);
    }

    public void toXML(Node parent) {
        Node grad = staticMethods.addNode(parent, XML_name, null);
        staticMethods.addNode(grad, XML_desc, this.description);
        StringBuilder colors = new StringBuilder();
        for (int i = 0; i < this.gradientMilestones.length - 1; ++i) {
            colors.append(this.gradientMilestones[i]);
            colors.append(",");
        }
        colors.append(this.gradientMilestones[this.gradientMilestones.length - 1]);
        staticMethods.addNode(grad, XML_color, colors.toString());
    }

    public static colorGradient fromXML(Node sourceNode) {
        String name = XML_name;
        String colors = null;
        NodeList nL = sourceNode.getChildNodes();
        for (int i = 0; i < nL.getLength(); ++i) {
            Node current = nL.item(i);
            if (current.getNodeName().equals(XML_desc)) {
                name = staticMethods.getNodeText(current);
                continue;
            }
            if (!current.getNodeName().equals(XML_color)) continue;
            colors = staticMethods.getNodeText(current);
        }
        if (colors == null) {
            return new colorGradient(name, rainbowInt, gradientSteps);
        }
        String[] singleColors = colors.split(",");
        int[] colorInts = new int[singleColors.length];
        for (int i = 0; i < colorInts.length; ++i) {
            colorInts[i] = Integer.decode(singleColors[i]);
        }
        return new colorGradient(name, colorInts, gradientSteps);
    }
}

