/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import javax.media.nativewindow.NativeSurface;
import jogamp.newt.Debug;

public class PinchToZoomGesture
implements GestureHandler {
    public static final boolean DEBUG = Debug.debug("Window.MouseEvent");
    private final NativeSurface surface;
    private final boolean allowMorePointer;
    private float zoom;
    private int zoomLastEdgeDist;
    private boolean zoomFirstTouch;
    private boolean zoomMode;
    private ZoomEvent zoomEvent;
    private final short[] pIds = new short[]{-1, -1};

    public PinchToZoomGesture(NativeSurface nativeSurface, boolean bl) {
        this.clear(true);
        this.surface = nativeSurface;
        this.allowMorePointer = bl;
        this.zoom = 1.0f;
    }

    public String toString() {
        return "PinchZoom[1stTouch " + this.zoomFirstTouch + ", in " + this.isWithinGesture() + ", has " + (null != this.zoomEvent) + ", zoom " + this.zoom + "]";
    }

    private int gesturePointers(MouseEvent mouseEvent, int n) {
        int n2 = 0;
        for (int i = mouseEvent.getPointerCount() - 1; i >= 0; --i) {
            short s;
            if (n == i || this.pIds[0] != (s = mouseEvent.getPointerId(i)) && this.pIds[1] != s) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public void clear(boolean bl) {
        this.zoomEvent = null;
        if (bl) {
            this.zoomLastEdgeDist = 0;
            this.zoomFirstTouch = true;
            this.zoomMode = false;
            this.pIds[0] = -1;
            this.pIds[1] = -1;
        }
    }

    @Override
    public boolean isWithinGesture() {
        return this.zoomMode;
    }

    @Override
    public boolean hasGesture() {
        return null != this.zoomEvent;
    }

    @Override
    public InputEvent getGestureEvent() {
        return this.zoomEvent;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final void setZoom(float f) {
        this.zoom = f;
    }

    @Override
    public boolean process(InputEvent inputEvent) {
        if (null != this.zoomEvent || !(inputEvent instanceof MouseEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)inputEvent;
        int n = mouseEvent.getPointerCount();
        if (mouseEvent.getPointerType(0).getPointerClass() != MouseEvent.PointerClass.Onscreen || !this.allowMorePointer && n > 2) {
            return false;
        }
        short s = mouseEvent.getEventType();
        boolean bl = this.surface.getWidth() >= this.surface.getHeight();
        switch (s) {
            case 203: {
                if (1 == n) {
                    this.pIds[0] = mouseEvent.getPointerId(0);
                    this.pIds[1] = -1;
                } else if (2 <= n) {
                    this.pIds[0] = mouseEvent.getPointerId(0);
                    this.pIds[1] = mouseEvent.getPointerId(1);
                }
                if (!DEBUG) break;
                System.err.println("XXX1: id0 " + this.pIds[0] + " -> idx0 " + 0 + ", id1 " + this.pIds[1] + " -> idx1 " + 1);
                System.err.println(this + ".pressed: down " + n + ", gPtr " + this.gesturePointers(mouseEvent, -1) + ", event " + mouseEvent);
                break;
            }
            case 204: {
                int n2 = this.gesturePointers(mouseEvent, 0);
                if (1 == n2) {
                    this.zoomFirstTouch = true;
                    this.zoomMode = false;
                } else if (0 == n2) {
                    this.clear(true);
                }
                if (!DEBUG) break;
                System.err.println(this + ".released: down " + n + ", gPtr " + n2 + ", event " + mouseEvent);
                break;
            }
            case 206: {
                if (2 > n) break;
                int n3 = this.gesturePointers(mouseEvent, -1);
                if (2 == n3) {
                    int n4 = mouseEvent.getPointerIdx(this.pIds[0]);
                    int n5 = mouseEvent.getPointerIdx(this.pIds[1]);
                    if (0 <= n4 && 0 <= n5) {
                        int n6;
                        int n7 = bl ? mouseEvent.getY(n4) : mouseEvent.getX(n4);
                        int n8 = n6 = bl ? mouseEvent.getY(n5) : mouseEvent.getX(n5);
                        if (this.zoomFirstTouch) {
                            this.zoomLastEdgeDist = Math.abs(n7 - n6);
                            this.zoomFirstTouch = false;
                            this.zoomMode = true;
                        } else if (this.zoomMode) {
                            int n9 = Math.abs(n7 - n6);
                            int n10 = n9 - this.zoomLastEdgeDist;
                            float f = bl ? (float)this.surface.getHeight() : (float)this.surface.getWidth();
                            float f2 = (float)n10 / f;
                            if (DEBUG) {
                                System.err.println("XXX2: id0 " + this.pIds[0] + " -> idx0 " + n4 + ", id1 " + this.pIds[1] + " -> idx1 " + n5);
                                System.err.println("XXX3: d " + n9 + ", ld " + this.zoomLastEdgeDist + ", dd " + n10 + ", screen " + f + " -> incr " + f2 + ", zoom " + this.zoom + " -> " + (this.zoom + f2));
                            }
                            this.zoom += f2;
                            if (2.0f < this.zoom) {
                                this.zoom = 2.0f;
                            } else if (0.0f > this.zoom) {
                                this.zoom = 0.0f;
                            }
                            this.zoomLastEdgeDist = n9;
                            this.zoomEvent = new ZoomEvent(mouseEvent.getSource(), mouseEvent.getWhen(), mouseEvent.getModifiers(), this, mouseEvent, this.zoom);
                        }
                    }
                }
                if (!DEBUG) break;
                System.err.println(this + ".dragged: down " + n + ", gPtr " + n3 + ", event " + mouseEvent);
                break;
            }
        }
        return null != this.zoomEvent;
    }

    public static class ZoomEvent
    extends GestureHandler.GestureEvent {
        private final MouseEvent pe;
        private final float zoom;

        public ZoomEvent(Object object, long l, int n, GestureHandler gestureHandler, MouseEvent mouseEvent, float f) {
            super(object, l, n, gestureHandler);
            this.pe = mouseEvent;
            this.zoom = f;
        }

        public final MouseEvent getTrigger() {
            return this.pe;
        }

        public final float getZoom() {
            return this.zoom;
        }
    }
}

