## Gridcoin Release Process

### Preparation
 - git checkout staging
 - git pull
 - git merge testnet
 - Update changelog and commit
 - Change version in configure.ac to [version] and set CLIENT_VERSION_IS_RELEASE to 'true' and commit
 - git push

### Merge to master
 - git checkout master
 - git pull
 - git merge --no-ff -S staging   # Merge and sign. Copy changelog into commit message, but remove any brackets as that is a git comment

The changelog can be conveniently generated by the following:

#### Gridcoin maintainers/release engineers, suggestion for writing release notes

 - Write release notes. git shortlog helps a lot, for example:

    git shortlog --no-merges tag1..tag2

 - Generate list of authors:

    git log --format='%aN' tag1..tag2 | sort -ui | sed -e 's/^/- /'

 - This helps for the changelog:
 
    git log --pretty=" - %b %s" --merges tag1..tag2 | sed -e 's/Merge pull request \(#[[:digit:]][[:digit:]]*\) from \([[:print:]][[:print:]]*\)\/[[:print:]]*/\1 (\@\2)/' -e 's/[[:space:]]\{2,\}/ /'

 - git checkout master-test
 - git merge master
 - (Do test builds of master-test to do sanify checks of release. This can be used for actual release build of the Windows builds because it is at the same commit.)
 - git checkout master
 - git push

### Tag
 - git tag -s [version]  # Paste previous commit message into this commit message
 - git push --tags

### Release
 - Go to https://github.com/gridcoin-community/Gridcoin-Research/releases/new
 - Tag version: [version]
 - Release title: [version], <leisure or mandatory as appropriate>
 - Copy/paste changelog into Description
 - Publish

### Finalize
 - git checkout development
 - git merge master
 - Edit configure.ac, increment version for development. Commit it.
 - git push

 - git checkout testnet
 - git merge development
 - git push

### Announce the release:
 - Reddit /r/Gridcoin, Discord, Slack, Hive, and Twitter
 - Update title of #gridcoin on IRC
