/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import com.google.protobuf.ByteString;
import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.lang.MutableString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.ArrayUtils;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ReadOriginInfo;
import org.campagnelab.goby.reads.QualityEncoding;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.campagnelab.goby.util.LogIsConfigured;
import org.campagnelab.goby.util.SamHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportableAlignmentEntryData {
    private static final Logger LOG = LoggerFactory.getLogger(ExportableAlignmentEntryData.class);
    private static final byte UNKNOWN_MAPPING_VALUE = 93;
    private static final int SAM_REVERSE_STRAND_FLAG = 16;
    private boolean debug;
    private RandomAccessSequenceInterface genome;
    private CharList refBases;
    private CharList readBases;
    private MutableString readBasesOriginal;
    private ByteList qualities;
    private MutableString cigarString;
    private MutableString mismatchString;
    private ArrayList<CharSequence> mismatchArray;
    private MutableString invalidMessage;
    private boolean hasQualities;
    private CharList actualReads;
    private ByteList actualQualities;
    private boolean invalid;
    private int startClip;
    private int endClip;
    private int queryLength;
    private int queryAlignedLength;
    private int targetAlignedLength;
    private boolean reverseStrand;
    private QualityEncoding qualityEncoding;
    private int endTargetPositionZeroBased;
    private Alignments.AlignmentEntry alignmentEntry;
    private ReadOriginInfo readOriginInfo;
    private boolean hasReadGroups;
    private String readGroup;
    private LinkedList<Integer> deleteQualityIndexes;
    private DoubleIndexedIdentifier targetIdentifiers;

    private ExportableAlignmentEntryData() {
    }

    public ExportableAlignmentEntryData(RandomAccessSequenceInterface genome, QualityEncoding qualityEncoding, DoubleIndexedIdentifier targetIdentifiers) {
        this.debug = LogIsConfigured.isConfigured() && LOG.isDebugEnabled();
        this.genome = genome;
        this.qualityEncoding = qualityEncoding;
        this.targetIdentifiers = targetIdentifiers;
        this.refBases = new CharArrayList();
        this.readBases = new CharArrayList();
        this.readBasesOriginal = new MutableString();
        this.qualities = new ByteArrayList();
        this.cigarString = new MutableString();
        this.mismatchString = new MutableString();
        this.mismatchArray = new ArrayList();
        this.invalidMessage = new MutableString();
        this.actualReads = new CharArrayList();
        this.actualQualities = new ByteArrayList();
        this.deleteQualityIndexes = new LinkedList();
        this.reset();
    }

    private void reset() {
        this.refBases.clear();
        this.readBases.clear();
        this.readBasesOriginal.setLength(0);
        this.qualities.clear();
        this.cigarString.setLength(0);
        this.mismatchString.setLength(0);
        this.mismatchArray.clear();
        this.invalidMessage.setLength(0);
        this.actualReads.clear();
        this.actualQualities.clear();
        this.invalid = false;
        this.startClip = 0;
        this.endClip = 0;
        this.queryLength = 0;
        this.queryAlignedLength = 0;
        this.targetAlignedLength = 0;
        this.reverseStrand = true;
        this.hasQualities = false;
        this.endTargetPositionZeroBased = 0;
        this.alignmentEntry = null;
        this.deleteQualityIndexes.clear();
    }

    public static ExportableAlignmentEntryData duplicateFrom(ExportableAlignmentEntryData from) {
        ExportableAlignmentEntryData to = new ExportableAlignmentEntryData(from.genome, from.qualityEncoding, from.targetIdentifiers);
        to.refBases.addAll(from.refBases);
        to.readBases.addAll(from.readBases);
        to.readBasesOriginal.append(from.readBasesOriginal);
        to.qualities.addAll(from.qualities);
        to.cigarString.append(from.cigarString);
        to.mismatchString.append(from.mismatchString);
        to.invalidMessage.append(from.invalidMessage);
        to.actualReads.addAll(from.actualReads);
        to.actualQualities.addAll(from.actualQualities);
        to.invalid = from.invalid;
        to.startClip = from.startClip;
        to.endClip = from.endClip;
        to.queryLength = from.queryLength;
        to.queryAlignedLength = from.queryAlignedLength;
        to.targetAlignedLength = from.targetAlignedLength;
        to.reverseStrand = from.reverseStrand;
        to.hasQualities = from.hasQualities;
        to.endTargetPositionZeroBased = from.endTargetPositionZeroBased;
        to.alignmentEntry = Alignments.AlignmentEntry.newBuilder(from.alignmentEntry).build();
        return to;
    }

    public int getTargetIndex() {
        return this.alignmentEntry.getTargetIndex();
    }

    public String getTargetName() {
        return this.genome.getReferenceName(this.alignmentEntry.getTargetIndex());
    }

    public int getPairFlags() {
        int flags;
        int n = flags = this.alignmentEntry.hasPairFlags() ? this.alignmentEntry.getPairFlags() : 0;
        if (this.alignmentEntry.getMatchingReverseStrand()) {
            flags |= 0x10;
        }
        return flags;
    }

    public String getReadName() {
        if (this.alignmentEntry.hasReadName()) {
            return this.alignmentEntry.getReadName();
        }
        return String.valueOf(this.alignmentEntry.getQueryIndex());
    }

    public int getQueryIndex() {
        return this.alignmentEntry.getQueryIndex();
    }

    public int getStartPosition() {
        return this.alignmentEntry.getPosition() + 1;
    }

    public int getMappingQuality() {
        return this.alignmentEntry.getMappingQuality();
    }

    public boolean hasMate() {
        return this.alignmentEntry.hasPairAlignmentLink();
    }

    public int getMateReferenceIndex() {
        return this.alignmentEntry.getPairAlignmentLink().getTargetIndex();
    }

    public int getMateAlignmentStart() {
        return this.alignmentEntry.getPairAlignmentLink().getPosition() + 1;
    }

    public int getInferredInsertSize() {
        return this.alignmentEntry.hasInsertSize() ? this.alignmentEntry.getInsertSize() : 0;
    }

    public Alignments.AlignmentEntry getAlignmentEntry() {
        return this.alignmentEntry;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String getInvalidMessage() {
        return this.invalidMessage.toString();
    }

    public CharList getReadBases() {
        return this.readBases;
    }

    public String getReadBasesOriginal() {
        return this.readBasesOriginal.toString();
    }

    public CharList getReferenceBases() {
        return this.refBases;
    }

    public String getCigarString() {
        return this.cigarString.toString();
    }

    public String getMismatchString() {
        return this.mismatchString.toString();
    }

    public ByteList getReadQualities() {
        return this.qualities;
    }

    private char complement(char base) {
        switch (base) {
            case 'A': {
                return 'T';
            }
            case 'C': {
                return 'G';
            }
            case 'T': {
                return 'A';
            }
            case 'G': {
                return 'C';
            }
        }
        return '?';
    }

    private void setActualReads(CharList reads, boolean reverseStrand) {
        if (reads == null || reads.isEmpty()) {
            return;
        }
        int size = reads.size();
        if (reverseStrand) {
            for (int i = size - 1; i >= 0; --i) {
                this.actualReads.add(this.complement(((Character)reads.get(i)).charValue()));
            }
        } else {
            CharListIterator charListIterator = reads.iterator();
            while (charListIterator.hasNext()) {
                char read = ((Character)charListIterator.next()).charValue();
                this.actualReads.add(read);
            }
        }
    }

    private void setActualQuals(ByteList quals, boolean reverseStrand) {
        if (quals == null || quals.isEmpty()) {
            return;
        }
        int size = quals.size();
        if (reverseStrand) {
            for (int i = size - 1; i >= 0; --i) {
                this.actualQualities.add(quals.get(i));
            }
        } else {
            ByteListIterator byteListIterator = quals.iterator();
            while (byteListIterator.hasNext()) {
                byte qual = (Byte)byteListIterator.next();
                this.actualQualities.add(qual);
            }
        }
    }

    public void buildFrom(Alignments.AlignmentEntry alignmentEntry) {
        this.buildFrom(alignmentEntry, null, (ByteList)(alignmentEntry.hasReadQualityScores() ? ByteArrayList.wrap((byte[])alignmentEntry.getReadQualityScores().toByteArray()) : null));
    }

    public void buildFrom(Alignments.AlignmentEntry alignmentEntry, CharList actualReadsSrc, ByteList actualQualitiesSrc) {
        this.reset();
        boolean predefinedQuals = alignmentEntry.hasReadQualityScores();
        this.reverseStrand = alignmentEntry.getMatchingReverseStrand();
        this.setActualReads(actualReadsSrc, this.reverseStrand);
        this.setActualQuals(actualQualitiesSrc, this.reverseStrand);
        this.startClip = alignmentEntry.getQueryPosition();
        this.queryLength = alignmentEntry.getQueryLength();
        this.queryAlignedLength = alignmentEntry.getQueryAlignedLength();
        this.targetAlignedLength = alignmentEntry.getTargetAlignedLength();
        this.endClip = this.queryLength - this.queryAlignedLength - this.startClip;
        int startPosition = alignmentEntry.getPosition();
        this.alignmentEntry = alignmentEntry;
        if (predefinedQuals) {
            for (byte qualByte : alignmentEntry.getReadQualityScores().toByteArray()) {
                this.qualities.add(qualByte);
            }
            this.hasQualities = true;
        }
        if (this.hasReadGroups) {
            int readOriginIndex = alignmentEntry.getReadOriginIndex();
            Alignments.ReadOriginInfo info = this.readOriginInfo.getInfo(readOriginIndex);
            if (info == null) {
                this.invalid = true;
                this.invalidMessage.append(String.format("Cannot export read group index=%d. Index was not found in the goby header.", readOriginIndex));
                if (this.debug) {
                    LOG.debug(this.invalidMessage.toString());
                }
            } else {
                this.readGroup = info.getOriginId();
            }
        }
        int numInserts = 0;
        int numDeletions = 0;
        for (Alignments.SequenceVariation seqvar : alignmentEntry.getSequenceVariationsList()) {
            int tosLength;
            String froms = seqvar.getFrom();
            String tos = seqvar.getTo();
            int fromsLength = froms.length();
            if (fromsLength != (tosLength = tos.length())) {
                this.invalid = true;
                this.invalidMessage.append("Error: Sequence variation for queryIndex=").append(alignmentEntry.getQueryIndex()).append(" Has an invalid sequence variation. from.length != to.length");
                if (this.debug) {
                    LOG.debug(this.invalidMessage.toString());
                }
                return;
            }
            for (int i = 0; i < froms.length(); ++i) {
                char from = froms.charAt(i);
                char to = tos.charAt(i);
                if (from == '-' && to == '-') {
                    this.invalid = true;
                    this.invalidMessage.append("Error: Sequence variation for queryIndex=").append(alignmentEntry.getQueryIndex()).append(" invalid. Both 'from' and 'to' bases both equal '-'");
                    if (this.debug) {
                        LOG.debug(this.invalidMessage.toString());
                    }
                    return;
                }
                if (from == '-') {
                    ++numInserts;
                    continue;
                }
                if (to != '-') continue;
                ++numDeletions;
            }
        }
        if (this.queryAlignedLength + numDeletions != this.targetAlignedLength + numInserts) {
            this.invalid = true;
            this.invalidMessage.append(String.format(" Error with queryIndex=%d. queryAlignedLength(%d) + numDeletions(%d) != targetAlignedLength(%d) + numInserts(%d). %nAlignment entry was: %s ", alignmentEntry.getQueryIndex(), this.queryAlignedLength, numDeletions, this.targetAlignedLength, numInserts, alignmentEntry.toString()));
            return;
        }
        int endOfLoop = Math.max(this.queryAlignedLength + this.startClip + this.endClip, this.targetAlignedLength + this.startClip + this.endClip + numInserts);
        int gobyAlignmentTargetIndex = alignmentEntry.getTargetIndex();
        MutableString genomeTargetName = this.targetIdentifiers.getId(gobyAlignmentTargetIndex);
        int genomeTargetIndex = this.genome.getReferenceIndex(genomeTargetName.toString());
        assert (genomeTargetIndex != -1) : String.format("The reference sequence %s must be found in the genome.", genomeTargetName);
        String predefStartClips = alignmentEntry.hasSoftClippedBasesLeft() ? alignmentEntry.getSoftClippedBasesLeft() : this.buildArrayOfNs(this.startClip);
        String predefEndClips = alignmentEntry.hasSoftClippedBasesRight() ? alignmentEntry.getSoftClippedBasesRight() : this.buildArrayOfNs(this.endClip);
        ByteString predefStartClipQuality = alignmentEntry.hasSoftClippedQualityLeft() ? alignmentEntry.getSoftClippedQualityLeft() : null;
        ByteString predefEndClipQuality = alignmentEntry.hasSoftClippedQualityRight() ? alignmentEntry.getSoftClippedQualityRight() : null;
        int genomeLength = this.genome.getLength(genomeTargetIndex);
        int rightClipIndex = 0;
        for (int i = 0; i < endOfLoop; ++i) {
            int genomePosition = i + startPosition - this.startClip;
            char base = genomePosition >= 0 && genomePosition < genomeLength ? (char)this.genome.get(genomeTargetIndex, genomePosition) : (char)'N';
            boolean qualAddedForClip = false;
            if (this.isClipPosition(endOfLoop, i)) {
                boolean leftClippedPosition = this.isLeftClippedPosition(endOfLoop, i, predefStartClips);
                boolean rightClippedPosition = this.isRightClippedPosition(endOfLoop, i, predefEndClips);
                if (leftClippedPosition || rightClippedPosition) {
                    char clipBase;
                    char c = clipBase = leftClippedPosition ? predefStartClips.charAt(i) : predefEndClips.charAt(rightClipIndex);
                    if (clipBase == '=') {
                        this.readBases.add(base);
                    } else {
                        this.readBases.add(clipBase);
                    }
                    if (!(predefinedQuals || predefStartClipQuality == null && predefEndClipQuality == null)) {
                        byte qual;
                        if (leftClippedPosition) {
                            qual = predefStartClipQuality != null ? (byte)predefStartClipQuality.byteAt(i) : (byte)93;
                        } else {
                            byte by = qual = predefEndClipQuality != null ? (byte)predefEndClipQuality.byteAt(rightClipIndex) : (byte)93;
                        }
                        assert (this.qualities != null) : "qualities field must never be null.";
                        this.qualities.add(qual);
                        qualAddedForClip = true;
                        if (rightClippedPosition) {
                            ++rightClipIndex;
                        }
                    }
                } else {
                    this.readBases.add(base);
                }
            } else {
                this.readBases.add(base);
            }
            this.refBases.add(base);
            if (predefinedQuals || qualAddedForClip) continue;
            this.qualities.add((byte)93);
        }
        if (!alignmentEntry.getSequenceVariationsList().isEmpty() && this.debug) {
            LOG.debug("Before sequence variation:");
            LOG.debug("\n" + this.toString());
        }
        int seqVarInsertsInRead = 0;
        for (Alignments.SequenceVariation seqvar : alignmentEntry.getSequenceVariationsList()) {
            if (this.debug) {
                LOG.debug(this.seqVarToString(seqvar));
            }
            String froms = seqvar.getFrom();
            String tos = seqvar.getTo();
            int startRefPosition = seqvar.getPosition() + this.startClip;
            byte[] toQuals = seqvar.hasToQuality() ? seqvar.getToQuality().toByteArray() : null;
            int seqVarInsertsInReadDelta = 0;
            int toQualIndex = 0;
            for (int i = 0; i < Math.min(froms.length(), tos.length()); ++i) {
                char from = froms.charAt(i);
                char to = tos.charAt(i);
                Byte toQual = toQuals == null ? null : Byte.valueOf((byte)this.qualityEncoding.phredQualityScoreToAsciiEncoding(to == '-' ? (byte)0 : toQuals[toQualIndex++]));
                int refPosition = startRefPosition + i - 1;
                if (from == '-') {
                    block53: {
                        try {
                            this.refBases.add(refPosition + seqVarInsertsInRead + 1, from);
                            this.readBases.add(refPosition + seqVarInsertsInRead + 1, to);
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.invalidMessage.append("Error: Index out of bounds exception for queryIndex=").append(alignmentEntry.getQueryIndex()).append(" refPosition=").append(refPosition).append(" seqVarInsertsInRead=").append(seqVarInsertsInRead).append(" refBases.size=").append(this.refBases.size()).append(" readBases.size=").append(this.readBases.size()).append('\n');
                            if (this.debug) {
                                LOG.warn(this.invalidMessage.toString());
                            }
                            if (!this.invalid) break block53;
                            return;
                        }
                    }
                    if (toQual != null && !predefinedQuals) {
                        this.qualities.add(refPosition + seqVarInsertsInRead + 1, (Object)toQual);
                        this.hasQualities = true;
                    }
                    ++seqVarInsertsInReadDelta;
                    continue;
                }
                if (to == '-') {
                    if (((Character)this.refBases.get(refPosition + seqVarInsertsInRead)).charValue() != from) {
                        this.invalid = false;
                        this.invalidMessage.append("Error: (Deletion) Sequence variation for queryIndex=").append(alignmentEntry.getQueryIndex()).append(" invalid. 'from' base doesn't match actual reference base. From=").append(from).append(" actual=").append(this.refBases.get(refPosition + seqVarInsertsInRead)).append('\n');
                        if (this.debug) {
                            LOG.warn(this.invalidMessage.toString());
                        }
                        if (this.invalid) {
                            return;
                        }
                    }
                    this.readBases.set(refPosition + seqVarInsertsInRead, '-');
                    if (predefinedQuals) continue;
                    this.deleteQualityIndexes.addFirst(refPosition + seqVarInsertsInRead);
                    continue;
                }
                if (((Character)this.refBases.get(refPosition + seqVarInsertsInRead)).charValue() != from) {
                    this.invalid = false;
                    this.invalidMessage.append("Error: (Mutation) Index out of bounds exception for queryIndex=").append(alignmentEntry.getQueryIndex()).append(" invalid. 'from' base doesn't match actual reference base. From=").append(from).append(" actual=").append(this.refBases.get(refPosition + seqVarInsertsInRead)).append('\n');
                    if (this.debug) {
                        LOG.warn(this.invalidMessage.toString());
                    }
                    if (this.invalid) {
                        return;
                    }
                }
                this.readBases.set(refPosition + seqVarInsertsInRead, to);
                if (toQual == null || predefinedQuals) continue;
                this.qualities.set(refPosition + seqVarInsertsInRead, (Object)toQual);
                this.hasQualities = true;
            }
            seqVarInsertsInRead += seqVarInsertsInReadDelta;
        }
        if (!predefinedQuals) {
            Iterator<Alignments.SequenceVariation> genomePosition = this.deleteQualityIndexes.iterator();
            while (genomePosition.hasNext()) {
                int deleteQualityIndex = (Integer)((Object)genomePosition.next());
                this.qualities.remove(deleteQualityIndex);
            }
        }
        if (numInserts > 0) {
            this.refBases.size(this.refBases.size() - numInserts);
            this.readBases.size(this.readBases.size() - numInserts);
            if (!predefinedQuals) {
                this.qualities.size(this.qualities.size() - numInserts);
            }
        }
        if (this.endClip > 0) {
            int readSize = this.readBases.size();
            int genomePosition = alignmentEntry.getPosition() + alignmentEntry.getQueryAlignedLength() + numDeletions - numInserts;
            for (int i = 0; i < Math.min(this.endClip, predefEndClips.length()); ++i) {
                int pos = readSize - this.endClip + i;
                if (predefEndClips == null) {
                    this.readBases.set(pos, 'N');
                    continue;
                }
                char clipBase = predefEndClips.charAt(i);
                if (clipBase == '=') {
                    char base = genomePosition >= 0 && genomePosition < genomeLength ? this.genome.get(genomeTargetIndex, genomePosition + i) : (char)'N';
                    this.readBases.set(pos, base);
                    continue;
                }
                this.readBases.set(pos, clipBase);
            }
        }
        CharListIterator charListIterator = this.readBases.iterator();
        while (charListIterator.hasNext()) {
            char readBase = ((Character)charListIterator.next()).charValue();
            if (readBase == '-') continue;
            this.readBasesOriginal.append(readBase);
        }
        this.observeReadRefDifferences();
        this.endTargetPositionZeroBased = alignmentEntry.getPosition() + this.targetAlignedLength;
        if (this.debug) {
            LOG.debug("\n" + this.toString());
        }
    }

    private String buildArrayOfNs(int length) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            result.append('N');
        }
        return result.toString();
    }

    private boolean isRightClippedPosition(int endOfLoop, int position, String endClips) {
        return position > endOfLoop - this.endClip && endClips != null && position < endClips.length();
    }

    private boolean isLeftClippedPosition(int endOfLoop, int i, String startClips) {
        return i < this.startClip && startClips != null && i < startClips.length();
    }

    private boolean isClipPosition(int endOfLoop, int position) {
        return position < this.startClip || position > endOfLoop - this.endClip;
    }

    public List<String> getBamAttributesList() {
        return this.alignmentEntry.getBamAttributesList();
    }

    public void setReadGroupInfo(ReadOriginInfo readOriginInfo) {
        this.readOriginInfo = readOriginInfo;
        this.hasReadGroups = true;
    }

    public String getReadGroup() {
        return this.readGroup;
    }

    public static ExportableAlignmentEntryData mergeSpliceFragments(List<ExportableAlignmentEntryData> fragments) {
        int i;
        ExportableAlignmentEntryData merged = fragments.get(0);
        Alignments.AlignmentEntry mergedAlignment = merged.alignmentEntry;
        int size = fragments.size();
        boolean predefinedQuals = false;
        for (i = 0; i < size; ++i) {
            Alignments.AlignmentEntry currentAlignment = fragments.get((int)i).alignmentEntry;
            if (!currentAlignment.hasReadQualityScores()) continue;
            merged.qualities.clear();
            predefinedQuals = true;
            for (byte qualByte : currentAlignment.getReadQualityScores().toByteArray()) {
                merged.qualities.add(qualByte);
            }
            break;
        }
        for (i = 1; i < size; ++i) {
            ExportableAlignmentEntryData fragment = fragments.get(i);
            Alignments.AlignmentEntry fragmentAlignment = fragment.alignmentEntry;
            if (mergedAlignment.getTargetIndex() != fragmentAlignment.getTargetIndex()) {
                merged.invalid = true;
                merged.invalidMessage.append("Error: Splice segments for queryIndex=").append(mergedAlignment.getQueryIndex()).append(" Are on different chromosomes.");
                if (merged.debug) {
                    LOG.debug(merged.invalidMessage.toString());
                }
                return merged;
            }
            merged.mergeCigars(fragment, predefinedQuals);
            if (merged.invalid) {
                return merged;
            }
            SamHelper.appendMismatches(merged.mismatchString, fragment.mismatchString);
            merged.readBasesOriginal.append(fragment.readBasesOriginal);
            if (predefinedQuals) continue;
            merged.qualities.addAll(fragment.qualities);
        }
        return merged;
    }

    private void mergeCigars(ExportableAlignmentEntryData other, boolean predefinedQuals) {
        int gap;
        Alignments.AlignmentEntry otherAlignmentEntry = other.alignmentEntry;
        if (this.alignmentEntry.getPosition() < otherAlignmentEntry.getPosition()) {
            boolean spliceInReverse = false;
            gap = otherAlignmentEntry.getPosition() - this.endTargetPositionZeroBased;
        } else {
            boolean spliceInReverse = true;
            gap = this.alignmentEntry.getPosition() - other.endTargetPositionZeroBased;
            this.swapFieldsForReverseSplice(other);
        }
        GobyCigarElement thisLastCigar = this.removeLastCigar();
        GobyCigarElement otherFirstCigar = other.removeFirstCigar();
        if (thisLastCigar.code == 'S' && otherFirstCigar.code == 'S') {
            this.readBasesOriginal.length(this.queryLength - thisLastCigar.size);
            other.readBasesOriginal.delete(0, otherFirstCigar.size);
            if (!predefinedQuals) {
                this.qualities.size(this.queryLength - thisLastCigar.size);
                other.qualities.removeElements(0, otherFirstCigar.size);
            }
            this.cigarString.append(gap).append('N');
            this.cigarString.append(other.cigarString);
            this.endTargetPositionZeroBased = other.endTargetPositionZeroBased;
        } else {
            this.invalid = true;
            this.cigarString.append(thisLastCigar.toString());
            other.cigarString.insert(0, otherFirstCigar.toString());
            this.invalidMessage.append("Splice cigar codes were incorrect for qi=").append(this.alignmentEntry.getQueryIndex()).append("\n");
            this.invalidMessage.append("this=").append(this.toString());
            this.invalidMessage.append("other=").append(other.toString());
        }
    }

    private void swapFieldsForReverseSplice(ExportableAlignmentEntryData other) {
        MutableString tempCigarString = this.cigarString;
        this.cigarString = other.cigarString;
        other.cigarString = tempCigarString;
        MutableString tempMismatchString = this.mismatchString;
        this.mismatchString = other.mismatchString;
        other.mismatchString = tempMismatchString;
        MutableString tempReadBasesOriginal = this.readBasesOriginal;
        this.readBasesOriginal = other.readBasesOriginal;
        other.readBasesOriginal = tempReadBasesOriginal;
        ByteList tempQualities = this.qualities;
        this.qualities = other.qualities;
        other.qualities = tempQualities;
    }

    public GobyCigarElement removeFirstCigar() {
        Matcher matcher = SamHelper.FIRST_CIGAR_PATTERN.matcher((CharSequence)this.cigarString);
        GobyCigarElement cigarElement = null;
        if (matcher.find()) {
            String matchStr = matcher.group(1);
            char matchCode = matcher.group(2).charAt(0);
            cigarElement = new GobyCigarElement(matchStr, matchCode);
            this.cigarString.delete(0, cigarElement.cigarWidth);
        }
        return cigarElement;
    }

    public GobyCigarElement removeLastCigar() {
        Matcher matcher = SamHelper.LAST_CIGAR_PATTERN.matcher((CharSequence)this.cigarString);
        GobyCigarElement cigarElement = null;
        if (matcher.find()) {
            String matchStr = matcher.group(1);
            char matchCode = matcher.group(2).charAt(0);
            cigarElement = new GobyCigarElement(matchStr, matchCode);
            this.cigarString.length(this.cigarString.length() - cigarElement.cigarWidth);
        }
        return cigarElement;
    }

    private void observeReadRefDifferences() {
        if (this.startClip > 0) {
            this.cigarString.append(this.startClip).append(CigarType.CLIP.code);
        }
        int startPos = this.startClip;
        int endPos = this.readBases.size() - this.endClip;
        CigarType lastCigarType = CigarType.MATCH;
        int numLastCigarType = 0;
        MismatchType lastMismatchType = MismatchType.MATCH;
        int numLastMismatchType = 0;
        for (int i = startPos; i < endPos; ++i) {
            MismatchType curMismatchType;
            CigarType curCigarType;
            if (i >= this.readBases.size()) {
                System.out.println("PROBLEM: " + this);
                break;
            }
            char readBase = ((Character)this.readBases.get(i)).charValue();
            char refBase = ((Character)this.refBases.get(i)).charValue();
            if (readBase == '-') {
                curCigarType = CigarType.DELETION;
                curMismatchType = MismatchType.DELETION;
            } else if (refBase == '-') {
                curCigarType = CigarType.INSERTION;
                curMismatchType = MismatchType.MATCH;
            } else {
                curCigarType = CigarType.MATCH;
                curMismatchType = readBase == refBase ? MismatchType.MATCH : MismatchType.MISMATCH;
            }
            if (curCigarType == lastCigarType) {
                ++numLastCigarType;
            } else {
                if (numLastCigarType > 0) {
                    this.cigarString.append(numLastCigarType).append(lastCigarType.code);
                }
                numLastCigarType = 1;
                lastCigarType = curCigarType;
            }
            if (curMismatchType != lastMismatchType) {
                if (lastMismatchType == MismatchType.MATCH && numLastMismatchType > 0) {
                    this.mismatchArray.add((CharSequence)new MutableString().append(numLastMismatchType));
                }
                numLastMismatchType = curCigarType == CigarType.INSERTION ? 0 : 1;
                lastMismatchType = curMismatchType;
            } else if (curCigarType != CigarType.INSERTION) {
                ++numLastMismatchType;
            }
            if (curMismatchType == MismatchType.DELETION) {
                MutableString deletion;
                if (numLastMismatchType == 1) {
                    deletion = new MutableString().append('^');
                    this.mismatchArray.add((CharSequence)deletion);
                } else {
                    deletion = (MutableString)this.mismatchArray.get(this.mismatchArray.size() - 1);
                }
                deletion.append(refBase);
            }
            if (curMismatchType != MismatchType.MISMATCH) continue;
            this.mismatchArray.add((CharSequence)new MutableString().append(refBase));
        }
        if (numLastCigarType > 0) {
            this.cigarString.append(numLastCigarType).append(lastCigarType.code);
        }
        if (lastMismatchType == MismatchType.MATCH && numLastMismatchType > 0) {
            this.mismatchArray.add((CharSequence)new MutableString().append(numLastMismatchType));
        }
        if (this.endClip > 0) {
            this.cigarString.append(this.endClip).append(CigarType.CLIP.code);
        }
        this.mismatchString.append(SamHelper.canonicalMdz(this.mismatchArray));
    }

    public String seqVarToString(Alignments.SequenceVariation seqvar) {
        byte[] toQuals = seqvar.hasToQuality() ? seqvar.getToQuality().toByteArray() : null;
        return String.format("seqvar=[from/ref:%s, to/read:%s%s, readIndex:%d, position:%d]%n", seqvar.getFrom(), seqvar.getTo(), toQuals == null ? "" : " " + ArrayUtils.toString((Object)toQuals), seqvar.getReadIndex(), seqvar.getPosition());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("queryIndex =").append(this.getQueryIndex()).append("\n");
        if (this.invalid) {
            sb.append("invalidMessage").append(this.invalidMessage.toString()).append("\n");
        }
        sb.append("targetIndex=").append(this.getTargetIndex()).append("\n");
        sb.append("targetName =").append(this.getTargetName()).append('\n');
        sb.append("fragIndex  =").append(this.alignmentEntry.getFragmentIndex()).append("\n");
        sb.append("startPos   =").append(this.getStartPosition()).append("\n");
        sb.append("startClip  =").append(this.startClip).append("\n");
        sb.append("endClip    =").append(this.endClip).append("\n");
        sb.append("queryLength=").append(this.queryLength).append("\n");
        sb.append("queryAlignedLength =").append(this.queryAlignedLength).append("\n");
        sb.append("targetAlignedLength=").append(this.targetAlignedLength).append("\n");
        sb.append("reverseStrand=").append(this.reverseStrand).append("\n");
        this.basesOutput(sb, "refBases    =", this.refBases, "readBases   =", this.readBases, "readBases.O =", this.readBasesOriginal, "actReadBases=", this.actualReads, "diff        =");
        sb.append("actQuals    =").append(this.qualsToStr(this.actualQualities)).append("\n");
        sb.append("quals       =").append(this.qualsToStr(this.qualities)).append("\n");
        sb.append("cigar       =").append(this.cigarString.toString()).append("\n");
        sb.append("md:z        =").append(this.mismatchString.toString()).append("\n");
        return sb.toString();
    }

    private String qualsToStr(ByteList quals) {
        if (quals == null || quals.isEmpty()) {
            return "[] size=0";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int qualsSize = quals.size();
        for (int i = 0; i < qualsSize; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.format("%03d", quals.get(i)));
        }
        sb.append("] size=").append(quals.size());
        return sb.toString();
    }

    private void basesOutput(StringBuilder sb, String prefixRefBases, CharList refBases, String prefixReadBases, CharList readBases, String prefixReadBasesOriginal, MutableString readBasesOriginal, String prefixActualReadBases, CharList actualReadBases, String diffPrefix) {
        char base;
        int refBasesSize = refBases.size();
        int readBasesSize = readBases.size();
        StringBuilder diff = new StringBuilder();
        for (int i = 0; i < Math.max(refBasesSize, readBasesSize); ++i) {
            int b2;
            int b1 = i < refBasesSize ? (int)((Character)refBases.get(i)).charValue() : 120;
            int n = b2 = i < readBasesSize ? (int)((Character)readBases.get(i)).charValue() : 120;
            if (b1 == b2) {
                diff.append('+');
                continue;
            }
            diff.append('x');
        }
        sb.append(prefixRefBases).append('[');
        CharListIterator charListIterator = refBases.iterator();
        while (charListIterator.hasNext()) {
            base = ((Character)charListIterator.next()).charValue();
            sb.append(base);
        }
        sb.append("] size=").append(refBases.size()).append('\n');
        sb.append(prefixReadBases).append('[');
        charListIterator = readBases.iterator();
        while (charListIterator.hasNext()) {
            base = ((Character)charListIterator.next()).charValue();
            sb.append(base);
        }
        sb.append("] size=").append(readBases.size()).append('\n');
        sb.append(prefixReadBasesOriginal).append('[');
        sb.append((CharSequence)readBasesOriginal);
        sb.append("] size=").append(readBasesOriginal.length()).append('\n');
        if (prefixActualReadBases != null) {
            sb.append(prefixActualReadBases).append('[');
            charListIterator = actualReadBases.iterator();
            while (charListIterator.hasNext()) {
                base = ((Character)charListIterator.next()).charValue();
                sb.append(base);
            }
            sb.append("] size=").append(actualReadBases.size()).append('\n');
        }
        if (diff.length() > 0) {
            sb.append(diffPrefix).append('[');
            sb.append(diff.toString());
            sb.append("] size=").append(diff.length()).append('\n');
        }
    }

    class GobyCigarElement {
        int size;
        char code;
        int cigarWidth;

        protected GobyCigarElement(String sizeStr, char code) {
            this.size = Integer.parseInt(sizeStr);
            this.code = code;
            this.cigarWidth = sizeStr.length() + 1;
        }

        public String toString() {
            return String.format("%d%c", this.size, Character.valueOf(this.code));
        }
    }

    private static enum CigarType {
        CLIP('S'),
        MATCH('M'),
        INSERTION('I'),
        DELETION('D');

        final char code;

        private CigarType(char code) {
            this.code = code;
        }
    }

    private static enum MismatchType {
        MATCH,
        INSERTION,
        DELETION,
        MISMATCH;

    }
}

