/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.ConcatAlignmentReader;

public class GenomicRange {
    private static final Log LOG = LogFactory.getLog(GenomicRange.class);
    public int startReferenceIndex;
    public String startChromosome = "?";
    public int startPosition;
    public int endReferenceIndex;
    public String endChromosome = "?";
    public int endPosition;
    private DoubleIndexedIdentifier ids;

    public GenomicRange() {
    }

    public String toString() {
        return String.format(" ]%d:%d-%d:%d] or ]%s:%d-%s-%d]", this.startReferenceIndex, this.startPosition, this.endReferenceIndex, this.endPosition, this.startChromosome, this.startPosition, this.endChromosome, this.endPosition);
    }

    public GenomicRange(int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) {
        this.startReferenceIndex = startReferenceIndex;
        this.endReferenceIndex = endReferenceIndex;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public void resolveChromosomeIndices(DoubleIndexedIdentifier referenceIds) {
        this.startReferenceIndex = referenceIds.getIndex(this.startChromosome);
        this.endReferenceIndex = referenceIds.getIndex(this.endChromosome);
    }

    public boolean fullyContains(String chromosome, int segmentStart, int segmentEnd) {
        assert (this.ids != null) : " identifiers must have been provided. Call setTargetIds to provide. ";
        int chromosomeIndex = this.ids.getIndex(chromosome);
        if (chromosomeIndex == -1) {
            return false;
        }
        if (chromosomeIndex < this.startReferenceIndex) {
            return false;
        }
        if (chromosomeIndex > this.endReferenceIndex) {
            return false;
        }
        if (chromosomeIndex == this.startReferenceIndex && segmentStart < this.startPosition) {
            return false;
        }
        return chromosomeIndex != this.endReferenceIndex || segmentEnd <= this.endPosition;
    }

    public boolean positionIsPastEnd(int referenceIndex, int position) {
        if (referenceIndex > this.endReferenceIndex) {
            return true;
        }
        return referenceIndex == this.endReferenceIndex && position > this.endPosition;
    }

    public boolean positionIsBeforeStart(int referenceIndex, int position) {
        if (referenceIndex < this.startReferenceIndex) {
            return true;
        }
        return referenceIndex == this.startReferenceIndex && position <= this.startPosition;
    }

    public boolean positionIsStrictlyBeforeStart(int referenceIndex, int position) {
        if (referenceIndex < this.startReferenceIndex) {
            return true;
        }
        return referenceIndex == this.startReferenceIndex && position < this.startPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTargetIds(String ... inputFilenames) {
        ConcatAlignmentReader concat = null;
        try {
            concat = new ConcatAlignmentReader(inputFilenames);
            concat.readHeader();
            this.setTargetIds(concat.getTargetIdentifiers());
            concat.close();
            concat = null;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to obtain target identifiers/index mapping from input alignments.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (concat != null) {
                try {
                    concat.close();
                }
                catch (IOException e) {
                    LOG.trace((Object)"Unable to close, ignoring");
                }
            }
        }
        return true;
    }

    public void setTargetIds(IndexedIdentifier targetIdentifiers) {
        this.ids = new DoubleIndexedIdentifier(targetIdentifiers);
        this.startReferenceIndex = this.ids.getIndex(this.startChromosome);
        this.endReferenceIndex = this.ids.getIndex(this.endChromosome);
    }

    public DoubleIndexedIdentifier getTargetIds() {
        return this.ids;
    }
}

