/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.Alignments;

public class PositionFacadeAlignmentReader
implements Closeable,
Iterator<Alignments.AlignmentEntry>,
Iterable<Alignments.AlignmentEntry> {
    private int endPosition;
    private int endReferenceIndex;
    private int startPosition;
    private int startReferenceIndex;
    private AlignmentReader delegate;
    Alignments.AlignmentEntry nextEntry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionFacadeAlignmentReader(String basename, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        try (AlignmentReaderImpl reader = null;){
            reader = new AlignmentReaderImpl(basename);
            reader.readHeader();
            if (!reader.isIndexed()) {
                throw new UnsupportedOperationException("The alignment must be sorted and indexed to read slices of data by reference position.");
            }
            reader.readIndex();
            long startOffset = reader.getByteOffset(startReferenceIndex, startPosition, 0);
            long endOffset = reader.getByteOffset(endReferenceIndex, endPosition + 1, 1);
            this.endPosition = endPosition;
            this.endReferenceIndex = endReferenceIndex;
            this.startPosition = startPosition;
            this.startReferenceIndex = startReferenceIndex;
            this.delegate = new AlignmentReaderImpl(startOffset, endOffset, basename);
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean hasNext() {
        int entryTargetIndex;
        if (this.nextEntry != null) {
            return true;
        }
        do {
            if (!this.delegate.hasNext()) {
                return false;
            }
            this.nextEntry = this.delegate.next();
        } while ((entryTargetIndex = this.nextEntry.getTargetIndex()) < this.startReferenceIndex || entryTargetIndex == this.startReferenceIndex && this.nextEntry.getPosition() < this.startPosition);
        if (entryTargetIndex > this.endReferenceIndex || entryTargetIndex == this.endReferenceIndex && this.nextEntry.getPosition() > this.endPosition) {
            this.nextEntry = null;
            return false;
        }
        return true;
    }

    @Override
    public Alignments.AlignmentEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Alignments.AlignmentEntry alignmentEntry = this.nextEntry;
            return alignmentEntry;
        }
        finally {
            this.nextEntry = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing elements is not supported by AlignmentReader implementations.");
    }

    @Override
    public Iterator<Alignments.AlignmentEntry> iterator() {
        return this;
    }
}

