/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.SequenceUtil;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.lang.MutableString;
import java.util.List;
import org.campagnelab.goby.readers.sam.GobySamRecord;
import org.campagnelab.goby.readers.sam.GobySamSegment;
import org.campagnelab.goby.reads.QualityEncoding;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.campagnelab.goby.util.LogIsConfigured;
import org.campagnelab.goby.util.WarningCounter;
import org.campagnelab.goby.util.pool.Resettable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamRecordParser
implements Resettable {
    private static final Logger LOG = LoggerFactory.getLogger(SamRecordParser.class);
    WarningCounter warnOnce = new WarningCounter(1);
    private final GobySamRecord gobySamRecord;
    private final MutableString diffBases;
    private final ByteList allReadQuals;
    private boolean hasReadQuals;
    private QualityEncoding qualityEncoding;
    private int numRecordsProcessed = 0;
    private int numRecordsSkipped = 0;
    private final boolean debug = LogIsConfigured.isConfigured();
    private final MutableString debugMessage;
    private RandomAccessSequenceInterface genome;

    public SamRecordParser() {
        this.qualityEncoding = QualityEncoding.SANGER;
        this.gobySamRecord = new GobySamRecord();
        this.diffBases = new MutableString();
        this.allReadQuals = new ByteArrayList();
        this.debugMessage = new MutableString();
    }

    @Override
    public void reset() {
        this.gobySamRecord.reset();
        this.diffBases.length(0);
        this.allReadQuals.clear();
        this.hasReadQuals = false;
    }

    public void clear() {
        this.numRecordsProcessed = 0;
        this.numRecordsSkipped = 0;
    }

    public int getNumRecordsSkipped() {
        return this.numRecordsSkipped;
    }

    public int getNumRecordsProcessed() {
        return this.numRecordsProcessed;
    }

    public QualityEncoding getQualityEncoding() {
        return this.qualityEncoding;
    }

    public void setQualityEncoding(QualityEncoding qualityEncoding) {
        this.qualityEncoding = qualityEncoding;
    }

    public GobySamRecord processRead(SAMRecord samRecord) {
        String allRefBases;
        if (samRecord.getReadUnmappedFlag()) {
            ++this.numRecordsSkipped;
            return null;
        }
        this.reset();
        int numInserts = 0;
        int numDeletes = 0;
        String md = samRecord.getStringAttribute(SAMTag.MD.name());
        if (md != null) {
            try {
                allRefBases = new String(SequenceUtil.makeReferenceFromAlignment((SAMRecord)samRecord, (boolean)true));
            }
            catch (SAMException e) {
                System.out.println("Illegal MD pattern skipped");
                return null;
            }
        } else {
            Object allRefBases2 = null;
            this.warnOnce.info(LOG, "MD tags not found. Reference bases of variations will be imported as 'N' for this alignment.", new Object[0]);
            return null;
        }
        String allReadBases = samRecord.getReadString();
        boolean reverseStrand = samRecord.getReadNegativeStrandFlag();
        int refStringPosition = 0;
        int readStringPosition = 0;
        int newRefStringPosition = 0;
        int newReadStringPosition = 0;
        int numSoftClippedBasesLeft = 0;
        int readIndex = reverseStrand ? samRecord.getReadLength() : 1;
        int refPosition = 1;
        int alignmentStartPosition = samRecord.getAlignmentStart();
        List cigarElementList = samRecord.getCigar().getCigarElements();
        int numCigarElements = cigarElementList.size();
        byte[] readQualsArray = samRecord.getBaseQualities();
        boolean bl = this.hasReadQuals = readQualsArray != null && readQualsArray.length > 0;
        if (this.hasReadQuals) {
            for (int i = 0; i < readQualsArray.length; ++i) {
                this.allReadQuals.add(readQualsArray[i]);
            }
        }
        if (this.debug && LOG.isDebugEnabled()) {
            this.debugMessage.length(0).append('\n');
            this.debugMessage.append("------------------------------------\n");
            this.debugMessage.append("Read Name=").append(samRecord.getReadName()).append('\n');
            this.debugMessage.append("Read length=").append(samRecord.getReadLength()).append('\n');
            this.debugMessage.append("Cigar=").append(samRecord.getCigarString()).append('\n');
            this.debugMessage.append("MD:Z=").append(samRecord.getStringAttribute("MD")).append('\n');
            this.debugOutputRefBases(allRefBases);
            this.debugOutputReadBases(allReadBases, reverseStrand);
            this.debugOutputReadQuals(readQualsArray.toString());
            this.debugMessage.append("Alignment Start Position = ").append(alignmentStartPosition).append('\n');
            this.debugMessage.append("Reverse strand? = ").append(reverseStrand).append('\n');
            LOG.debug(this.debugMessage.toString());
            LOG.debug("Cigar Ops:");
        }
        this.gobySamRecord.query = allReadBases;
        this.gobySamRecord.readQuals = this.allReadQuals;
        this.gobySamRecord.targetIndex = samRecord.getReferenceIndex();
        if (samRecord.getReadPairedFlag() && !samRecord.getMateUnmappedFlag()) {
            this.gobySamRecord.hasMate = true;
            this.gobySamRecord.mateTargetIndex = samRecord.getMateReferenceIndex();
            this.gobySamRecord.mateStartPosition = samRecord.getMateAlignmentStart() - 1;
        } else {
            this.gobySamRecord.hasMate = false;
        }
        this.gobySamRecord.readName.append(samRecord.getReadName());
        this.gobySamRecord.pairFlags = samRecord.getFlags();
        this.gobySamRecord.readNum = this.numRecordsProcessed + this.numRecordsSkipped;
        this.gobySamRecord.reverseStrand = reverseStrand;
        GobySamSegment segment = null;
        if (md == null && samRecord.getReadUnmappedFlag()) {
            return null;
        }
        for (int cigarElementNum = 0; cigarElementNum < numCigarElements; ++cigarElementNum) {
            int i;
            CigarElement cigarElement = (CigarElement)cigarElementList.get(cigarElementNum);
            CigarOperator cigarOperator = cigarElement.getOperator();
            int cigarLength = cigarElement.getLength();
            if (segment == null) {
                segment = this.gobySamRecord.addSegment();
                segment.position = alignmentStartPosition - 1 + refStringPosition - numDeletes - numSoftClippedBasesLeft;
                segment.reverseStrand = reverseStrand;
            }
            int readIndexDelta = 0;
            int refPositionDelta = 0;
            if (this.debug && LOG.isDebugEnabled()) {
                LOG.debug("--new cigar element--");
            }
            if (cigarOperator == CigarOperator.D) {
                numDeletes += cigarLength;
            } else if (cigarOperator == CigarOperator.I) {
                numInserts += cigarLength;
            }
            if (this.debug && LOG.isDebugEnabled()) {
                LOG.debug(String.format("   op=%s len=%d consumesReads=%s consumesRefs=%s", cigarOperator.name(), cigarLength, cigarOperator.consumesReadBases() ? "Yes" : "No", cigarOperator.consumesReferenceBases() ? "Yes" : "No"));
            }
            if (cigarOperator.consumesReadBases()) {
                int readStringEnd = readStringPosition + cigarLength;
                if (cigarOperator == CigarOperator.S) {
                    if (cigarElementNum == 0) {
                        segment.softClippedBasesLeft.append(allReadBases.substring(readStringPosition, readStringEnd));
                        this.copyQuality(this.hasReadQuals, this.allReadQuals, segment.softClippedQualityLeft, readStringPosition, readStringEnd);
                        numSoftClippedBasesLeft += cigarLength;
                    } else if (cigarElementNum == numCigarElements - 1) {
                        segment.softClippedBasesRight.append(allReadBases.substring(readStringPosition, readStringEnd));
                        this.copyQuality(this.hasReadQuals, this.allReadQuals, segment.softClippedQualityRight, readStringPosition, readStringEnd);
                    }
                } else {
                    segment.setPositions(readStringPosition, readIndex, refPosition);
                    segment.readBases.append(allReadBases.substring(readStringPosition, readStringEnd));
                    if (this.hasReadQuals) {
                        segment.readQuals.addAll(this.allReadQuals.subList(readStringPosition, readStringEnd));
                    }
                    segment.queryAlignedLength += cigarLength;
                }
                newReadStringPosition = readStringEnd;
                readIndexDelta += cigarLength;
            } else if (cigarOperator == CigarOperator.N) {
                segment.distanceToNextSegment = cigarLength;
                segment = null;
                if (this.debug && LOG.isDebugEnabled()) {
                    LOG.debug("Splice length = " + cigarLength);
                }
                refPositionDelta = -refPosition - cigarLength + 1;
            } else if (cigarOperator == CigarOperator.D) {
                for (int i2 = 0; i2 < cigarLength; ++i2) {
                    segment.readBases.append("-");
                    if (!this.hasReadQuals) continue;
                    segment.readQuals.add((byte)-1);
                }
            }
            if (md == null) {
                return null;
            }
            assert (md != null) : "MD tags missing from bam file for a mapped read?";
            int endIndex = Math.min(allRefBases.length(), refStringPosition + cigarLength);
            if (cigarOperator.consumesReferenceBases()) {
                if (cigarOperator != CigarOperator.N) {
                    if (allRefBases == null) {
                        for (i = 0; i < cigarLength; ++i) {
                            segment.refBases.append('N');
                        }
                    } else {
                        segment.refBases.append(allRefBases.substring(refStringPosition, endIndex));
                    }
                    segment.targetAlignedLength += cigarLength;
                }
                refPositionDelta += cigarLength;
            } else if (cigarOperator == CigarOperator.I) {
                for (i = 0; i < cigarLength; ++i) {
                    segment.refBases.append("-");
                }
            }
            refStringPosition = newRefStringPosition = endIndex;
            readStringPosition = newReadStringPosition;
            readIndex += (reverseStrand ? -1 : 1) * readIndexDelta;
            refPosition += refPositionDelta;
        }
        this.gobySamRecord.observeVariations();
        this.gobySamRecord.numDeletes = numDeletes;
        this.gobySamRecord.numInserts = numInserts;
        ++this.numRecordsProcessed;
        return this.gobySamRecord;
    }

    private void copyQuality(boolean hasReadQuals, ByteList source, ByteList destination, int readStringPosition, int readStringEnd) {
        if (hasReadQuals) {
            destination.size(0);
            for (int i = readStringPosition; i < readStringEnd; ++i) {
                destination.add(source.get(i));
            }
        }
    }

    private void debugOutputRefBases(String refs) {
        this.debugMessage.append("             ");
        int refPosition = 0;
        for (char c : refs.toCharArray()) {
            if (c == 'N') {
                refPosition = 0;
                this.debugMessage.append("_");
                continue;
            }
            if (c != '-' && c != '0') {
                ++refPosition;
            }
            this.debugMessage.append(refPosition % 10);
        }
        this.debugMessage.append('\n');
        this.debugMessage.append("allRefBases =").append(refs).append('\n');
    }

    private void debugOutputReadBases(String reads, boolean reverseStrand) {
        this.debugMessage.append("allReadBases=").append(reads).append('\n');
        this.debugMessage.append("             ");
        if (reverseStrand) {
            for (int i = reads.length(); i >= 1; --i) {
                this.debugMessage.append(i % 10);
            }
        } else {
            for (int i = 0; i < reads.length(); ++i) {
                this.debugMessage.append((i + 1) % 10);
            }
        }
        this.debugMessage.append('\n');
    }

    private void debugOutputReadQuals(String readQualsString) {
        this.debugMessage.append("readQualsStr=").append(readQualsString).append('\n');
        this.debugMessage.append("allReadQuals=");
        if (this.hasReadQuals) {
            for (int i = 0; i < this.allReadQuals.size(); ++i) {
                if (i > 0) {
                    this.debugMessage.append(',');
                }
                this.debugMessage.append('[').append(i).append(':').append(this.allReadQuals.get(i)).append(']');
            }
        } else {
            this.debugMessage.append("None");
        }
        this.debugMessage.append('\n');
    }

    public void setGenome(RandomAccessSequenceInterface genome) {
        this.genome = genome;
    }
}

