/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import org.campagnelab.goby.util.LongNamedCounter;

public class NamedCounters {
    private ObjectArrayList<LongNamedCounter[]> counters;
    int numFiles;
    private ObjectSet<String> names = new ObjectOpenHashSet();
    private Object2IntMap<String> nameToIndex = new Object2IntOpenHashMap();
    private int index = 0;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String name : this.names) {
            buffer.append(String.format("[%s: %s]%n", name, ObjectArrayList.wrap((Object[])this.getArray(name))));
        }
        return buffer.toString();
    }

    public NamedCounters(int numFiles) {
        this.counters = new ObjectArrayList();
        this.numFiles = numFiles;
    }

    public void register(String name, int numFiles) {
        if (!this.names.contains((Object)name)) {
            this.counters.add((Object)new LongNamedCounter[numFiles]);
            this.nameToIndex.put((Object)name, this.index);
            for (int fileIndex = 0; fileIndex < numFiles; ++fileIndex) {
                ((LongNamedCounter[])this.counters.get((int)this.index))[fileIndex] = new LongNamedCounter(name);
            }
            ++this.index;
        }
    }

    public LongNamedCounter[] getArray(String name) {
        return (LongNamedCounter[])this.counters.get(this.nameToIndex.getInt((Object)name));
    }

    public LongNamedCounter get(String name, int fileIndex) {
        assert (this.nameToIndex.containsKey((Object)name)) : "counter name must exist: " + name;
        int counterIndex = this.nameToIndex.getInt((Object)name);
        return ((LongNamedCounter[])this.counters.get(counterIndex))[fileIndex];
    }

    public String[] ids() {
        return (String[])this.nameToIndex.keySet().toArray((Object[])new String[this.nameToIndex.size()]);
    }
}

