/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import java.io.Serializable;
import java.util.Set;

public class Variant
implements Serializable {
    public String referenceBase;
    public Set<FromTo> trueAlleles;
    public int position;
    public int referenceIndex;
    int maxLen;
    public static int numFromMistmaches = 0;
    public static int numIndelsEncountered = 0;
    public static final long serialVersionUID = -8298131465187158713L;

    public void merge(Variant reVar) {
        assert (this.referenceBase.equals(reVar.referenceBase)) : String.format("reference base must match for correct merging. %s !=%s Position=%d", this.referenceBase, reVar.referenceBase, this.position);
        assert (this.position == reVar.position) : String.format("position must match for correct merging. %d != %d", this.position);
        assert (this.referenceIndex == reVar.referenceIndex) : "referenceIndex must match for correct merging.";
        for (FromTo trueAllele : this.trueAlleles) {
            if (!trueAllele.getTo().equals(trueAllele.getFrom())) continue;
            this.trueAlleles.remove(trueAllele);
            break;
        }
        for (FromTo addingAllele : reVar.trueAlleles) {
            if (addingAllele.getTo().equals(addingAllele.getFrom())) continue;
            this.trueAlleles.add(addingAllele);
        }
        this.maxLen = this.getMaxLen();
    }

    public Variant(char referenceBase, Set<FromTo> alleles, int position, int referenceIndex) {
        this.referenceBase = Character.toString(referenceBase);
        this.trueAlleles = alleles;
        this.maxLen = this.getMaxLen();
        this.position = position;
        this.referenceIndex = referenceIndex;
    }

    public boolean isIndel() {
        for (FromTo allele : this.trueAlleles) {
            if (!allele.isIndel()) continue;
            return true;
        }
        return false;
    }

    public boolean isSNP() {
        for (FromTo allele : this.trueAlleles) {
            if (!allele.isSnp()) continue;
            return true;
        }
        return false;
    }

    public boolean isNoCall() {
        return this.trueAlleles.size() == 0;
    }

    public boolean isHomozygous() {
        return this.trueAlleles.size() == 1;
    }

    public boolean isHeterozygous() {
        return !this.isNoCall() && !this.isHomozygous();
    }

    static String pad(int maxLen, String s) {
        StringBuffer pad = new StringBuffer(s);
        for (int i = 1; i <= maxLen; ++i) {
            if (pad.length() >= maxLen) continue;
            pad.append("-");
        }
        return pad.toString();
    }

    private int getMaxLen() {
        int maxLen = 0;
        for (FromTo allele : this.trueAlleles) {
            maxLen = Math.max(maxLen, allele.maxLen());
        }
        return maxLen;
    }

    public String toString() {
        return "Variant{reference='" + this.referenceBase + '\'' + ", trueAlleles=" + this.trueAlleles + ", isIndel=" + this.isIndel() + ", isSNP=" + this.isSNP() + ", position=" + this.position + ", referenceIndex=" + this.referenceIndex + ", maxLen=" + this.maxLen + '}';
    }

    public static class GobyIndelFromVCF {
        private FromTo gobyFromTo;
        private int allelePos;

        public FromTo getGobyFromTo() {
            return this.gobyFromTo;
        }

        public int getAllelePos() {
            return this.allelePos;
        }

        public GobyIndelFromVCF(FromTo vcfFromTo, int gobyPosOfRefBase) {
            int diffStart;
            int maxLenRefThisAllele = Math.max(vcfFromTo.from.length(), vcfFromTo.to.length());
            String fromAffix = Variant.pad(maxLenRefThisAllele, vcfFromTo.from);
            String toAffix = Variant.pad(maxLenRefThisAllele, vcfFromTo.to);
            this.allelePos = gobyPosOfRefBase - 1;
            if (toAffix.substring(1).equals(fromAffix.substring(1))) {
                ++this.allelePos;
            }
            for (diffStart = 0; diffStart < fromAffix.length(); ++diffStart) {
                if (fromAffix.charAt(diffStart) == toAffix.charAt(diffStart)) continue;
                fromAffix = fromAffix.substring(diffStart);
                toAffix = toAffix.substring(diffStart);
                this.allelePos += diffStart;
                break;
            }
            for (diffStart = fromAffix.length() - 1; diffStart >= 0; --diffStart) {
                if (fromAffix.charAt(diffStart) == toAffix.charAt(diffStart)) continue;
                fromAffix = fromAffix.substring(0, diffStart + 1);
                toAffix = toAffix.substring(0, diffStart + 1);
                break;
            }
            this.gobyFromTo = new FromTo(fromAffix, toAffix);
        }
    }

    public static class FromTo
    implements Serializable {
        public static final long serialVersionUID = -894836569024658713L;
        public int sampleIndex;
        String from;
        String to;
        String originalFrom;
        String originalTo;

        public FromTo(String from, String to) {
            this(from, to, -1);
        }

        public FromTo(String from, String to, int sampleIndex) {
            this.originalFrom = from;
            this.originalTo = to;
            this.from = from;
            this.to = to;
            this.sampleIndex = sampleIndex;
            if (to.length() < from.length()) {
                this.to = this.to + from.substring(to.length(), from.length());
            }
            if (from.length() < to.length()) {
                this.from = this.from + to.substring(from.length(), to.length());
            }
        }

        public void makeUpperCase() {
            this.from = this.from.toUpperCase();
            this.to = this.to.toUpperCase();
        }

        public boolean isRef() {
            return this.from.equals(this.to);
        }

        public boolean isSnp() {
            return this.from.length() == 1 && this.to.length() == 1 && !this.isRef();
        }

        public boolean isIndel() {
            return this.from.length() != this.to.length() || this.from.contains("-") || this.to.contains("-");
        }

        public int maxLen() {
            return Math.max(this.from.length(), this.to.length());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!FromTo.class.isAssignableFrom(obj.getClass())) {
                return false;
            }
            FromTo other = (FromTo)obj;
            return this.from.equals(other.from) && this.to.equals(other.to) && this.sampleIndex == other.sampleIndex;
        }

        public int hashCode() {
            return this.from.hashCode() ^ this.to.hashCode();
        }

        public String toString() {
            return "from:" + this.from + " to:" + this.to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public void append(String substring) {
            this.from = this.from + substring;
            this.to = this.to + substring;
        }

        public String getOriginalFrom() {
            return this.originalFrom;
        }

        public String getOriginalTo() {
            return this.originalTo;
        }
    }
}

