/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs.error;

import gov.nih.nlm.ncbi.ngs.error.cause.LibraryLoadCause;

public class LibraryLoadError
extends ExceptionInInitializerError {
    String libName;
    LibraryLoadCause cause;
    String errorMessage;
    String recommendation;

    public LibraryLoadError(String string, String string2, LibraryLoadCause libraryLoadCause) {
        this(string, string2, libraryLoadCause, libraryLoadCause.getRecommendation());
    }

    public LibraryLoadError(String string, String string2, LibraryLoadCause libraryLoadCause, String string3) {
        super(LibraryLoadError.generateMsg(string, string2, libraryLoadCause, string3));
        this.libName = string;
        this.cause = libraryLoadCause;
        this.errorMessage = LibraryLoadError.generateMsg(string, string2, libraryLoadCause, null);
        this.recommendation = string3;
    }

    @Override
    public LibraryLoadCause getCause() {
        return this.cause;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    private static String generateMsg(String string, String string2, LibraryLoadCause libraryLoadCause, String string3) {
        String string4 = "Failed to load '" + string + "' - " + string2;
        if (libraryLoadCause != null) {
            string4 = string4 + ", " + libraryLoadCause.getMessage();
            if (string3 != null) {
                string4 = string4 + "\n" + string3;
            }
        }
        return string4;
    }
}

