/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.StringParser;

public class FlaggedOption
extends Option
implements Flagged {
    private char shortFlag = '\u0000';
    private String longFlag = JSAP.NO_LONGFLAG;
    private boolean allowMultipleDeclarations = false;

    public FlaggedOption(String id) {
        super(id);
    }

    public FlaggedOption(String id, StringParser stringParser, String defaultValue, boolean required, char shortFlag, String longFlag, String help) {
        this(id);
        this.setStringParser(stringParser);
        this.setDefault(defaultValue);
        this.setShortFlag(shortFlag);
        this.setLongFlag(longFlag);
        this.setRequired(required);
        this.setHelp(help);
    }

    public FlaggedOption(String id, StringParser stringParser, String defaultValue, boolean required, char shortFlag, String longFlag) {
        this(id, stringParser, defaultValue, required, shortFlag, longFlag, JSAP.NO_HELP);
    }

    public FlaggedOption setShortFlag(char shortFlag) {
        this.enforceParameterLock();
        this.shortFlag = shortFlag;
        return this;
    }

    @Override
    public char getShortFlag() {
        return this.shortFlag;
    }

    @Override
    public Character getShortFlagCharacter() {
        return this.shortFlag == '\u0000' ? null : new Character(this.shortFlag);
    }

    public FlaggedOption setLongFlag(String longFlag) {
        this.enforceParameterLock();
        this.longFlag = longFlag;
        return this;
    }

    public FlaggedOption setUsageName(String usageName) {
        this._setUsageName(usageName);
        return this;
    }

    @Override
    public String getLongFlag() {
        return this.longFlag;
    }

    public FlaggedOption setAllowMultipleDeclarations(boolean allowMultipleDeclarations) {
        this.enforceParameterLock();
        this.allowMultipleDeclarations = allowMultipleDeclarations;
        return this;
    }

    public boolean allowMultipleDeclarations() {
        return this.allowMultipleDeclarations;
    }

    @Override
    public String getSyntax() {
        StringBuffer result = new StringBuffer();
        if (!this.required()) {
            result.append("[");
        }
        if (this.getLongFlag() != JSAP.NO_LONGFLAG || this.getShortFlag() != '\u0000') {
            if (this.getLongFlag() == JSAP.NO_LONGFLAG) {
                result.append("-" + this.getShortFlag() + JSAP.SYNTAX_SPACECHAR);
            } else if (this.getShortFlag() == '\u0000') {
                result.append("--" + this.getLongFlag() + JSAP.SYNTAX_SPACECHAR);
            } else {
                result.append("(-" + this.getShortFlag() + "|--" + this.getLongFlag() + ")" + JSAP.SYNTAX_SPACECHAR);
            }
        }
        String un = this.getUsageName();
        char sep = this.getListSeparator();
        if (this.isList()) {
            result.append(un + "1" + sep + un + "2" + sep + "..." + sep + un + "N ");
        } else {
            result.append("<" + this.getUsageName() + ">");
        }
        if (!this.required()) {
            result.append("]");
        }
        return result.toString();
    }

    public FlaggedOption setList(boolean isList) {
        super.internalSetList(isList);
        return this;
    }

    public FlaggedOption setListSeparator(char listSeparator) {
        super.internalSetListSeparator(listSeparator);
        return this;
    }

    public FlaggedOption setRequired(boolean required) {
        super.internalSetRequired(required);
        return this;
    }

    public FlaggedOption setDefault(String[] defaultValues) {
        this._setDefault(defaultValues);
        return this;
    }

    public FlaggedOption setDefault(String defaultValue) {
        this._setDefault(defaultValue);
        return this;
    }

    public FlaggedOption setStringParser(StringParser stringParser) {
        super.internalSetStringParser(stringParser);
        return this;
    }
}

