/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.util.Arrays;
import java.util.StringTokenizer;

public class EnumeratedStringParser
extends StringParser {
    public static final char CONSTRUCTOR_VALUE_SEPARATOR = ';';
    private String[] validOptionValuesArray = null;
    private boolean isCaseSensitive;
    private boolean checkOptionChars;

    public static EnumeratedStringParser getParser(String validOptionValues, boolean caseSensitive, boolean checkOptionChars) throws IllegalArgumentException {
        return new EnumeratedStringParser(validOptionValues, caseSensitive, checkOptionChars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumeratedStringParser(String validOptionValues, boolean caseSensitive, boolean checkOptionChars) throws IllegalArgumentException {
        if (validOptionValues == null) {
            throw new IllegalArgumentException("EnumeratedStringParser validOptions parameter is null");
        }
        if (validOptionValues.length() == 0) {
            throw new IllegalArgumentException("EnumeratedStringParser validOptions parameter is empty");
        }
        this.isCaseSensitive = caseSensitive;
        this.checkOptionChars = checkOptionChars;
        if (validOptionValues.indexOf(59) == -1) {
            this.validOptionValuesArray = new String[1];
            if (!this.isValidOptionName(validOptionValues)) throw new IllegalArgumentException("Wrong character in EnumeratedStringParser option value: " + validOptionValues + "\nsee EnumeratedStringParser javadoc for more information");
            this.validOptionValuesArray[0] = validOptionValues;
            return;
        } else {
            StringTokenizer stok = new StringTokenizer(validOptionValues, ";");
            this.validOptionValuesArray = new String[stok.countTokens()];
            int i = 0;
            while (stok.hasMoreTokens()) {
                String value = stok.nextToken().trim();
                if (!this.isCaseSensitive) {
                    value = value.toLowerCase();
                }
                if (!this.isValidOptionName(value)) throw new IllegalArgumentException("Wrong character in EnumeratedStringParser option value: " + value + "\nsee EnumeratedStringParser javadoc for more information");
                this.validOptionValuesArray[i++] = value;
            }
        }
    }

    public static EnumeratedStringParser getParser(String validOptionValues, boolean caseSensitive) throws IllegalArgumentException {
        return new EnumeratedStringParser(validOptionValues, caseSensitive, true);
    }

    public EnumeratedStringParser(String validOptionValues, boolean caseSensitive) throws IllegalArgumentException {
        this(validOptionValues, caseSensitive, true);
    }

    public static EnumeratedStringParser getParser(String validOptionValues) throws IllegalArgumentException {
        return new EnumeratedStringParser(validOptionValues, false, true);
    }

    public EnumeratedStringParser(String validOptionValues) throws IllegalArgumentException {
        this(validOptionValues, false, true);
    }

    @Override
    public Object parse(String arg) throws ParseException {
        if (arg == null) {
            return null;
        }
        if (!this.isCaseSensitive) {
            arg = arg.toLowerCase();
        }
        if (!this.isValidOptionName(arg)) {
            throw new ParseException("Wrong character in command line option value for enumerated option: '" + arg + "'" + "\nallowed are alphanumeric characters + '$' and '_' sign only", new IllegalArgumentException());
        }
        if (Arrays.asList(this.validOptionValuesArray).contains(arg)) {
            return arg;
        }
        throw new ParseException("Option has wrong value '" + arg + "'" + "; valid values are: " + Arrays.asList(this.validOptionValuesArray), new IllegalArgumentException());
    }

    protected boolean isValidOptionName(String name) {
        if (!this.checkOptionChars) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

