/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.utils.ValidationUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SliceBlocks {
    private Block coreBlock;
    private Map<Integer, Block> externalBlocks = new TreeMap<Integer, Block>();

    public SliceBlocks(Block coreBlock, List<Block> externalBlocks) {
        ValidationUtils.nonNull(coreBlock, "A core block is required");
        ValidationUtils.validateArg(externalBlocks != null && externalBlocks.size() != 0, "A core block is required");
        this.setCoreBlock(coreBlock);
        for (Block block : externalBlocks) {
            this.addExternalBlock(block);
        }
    }

    public SliceBlocks(CRAMVersion cramVersion, int numberOfBlocks, InputStream inputStream) {
        block4: for (int i = 0; i < numberOfBlocks; ++i) {
            Block block = Block.read(cramVersion, inputStream);
            switch (block.getContentType()) {
                case CORE: {
                    this.setCoreBlock(block);
                    continue block4;
                }
                case EXTERNAL: {
                    this.addExternalBlock(block);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + block.getContentType().name());
                }
            }
        }
        if (this.getCoreBlock() == null) {
            throw new CRAMException("A core block is required in a CRAM stream but none was found.");
        }
    }

    public Block getCoreBlock() {
        return this.coreBlock;
    }

    public Block getExternalBlock(Integer contentID) {
        return this.externalBlocks.get(contentID);
    }

    public List<Integer> getExternalContentIDs() {
        return new ArrayList<Integer>(this.externalBlocks.keySet());
    }

    public int getNumberOfExternalBlocks() {
        return this.externalBlocks.size();
    }

    public void writeBlocks(CRAMVersion cramVersion, OutputStream outputStream) {
        if (this.coreBlock == null) {
            throw new IllegalArgumentException("A core block must be provided before slice blocks can be written to a CRAM stream");
        }
        this.coreBlock.write(cramVersion, outputStream);
        for (Block block : this.externalBlocks.values()) {
            block.write(cramVersion, outputStream);
        }
    }

    private void setCoreBlock(Block coreBlock) {
        ValidationUtils.nonNull(coreBlock);
        ValidationUtils.validateArg(coreBlock.getContentType() == BlockContentType.CORE, "Invalid slice core block");
        ValidationUtils.validateArg(this.coreBlock == null, "Can't reset slice core block");
        this.coreBlock = coreBlock;
    }

    private void addExternalBlock(Block externalBlock) {
        ValidationUtils.validateArg(externalBlock.getContentType() == BlockContentType.EXTERNAL, "Invalid external block");
        if (this.externalBlocks.containsKey(externalBlock.getContentId())) {
            throw new CRAMException(String.format("Attempt to add a duplicate block (id %d of type %s) to compression header encoding map. Existing block is of type %s.", new Object[]{externalBlock.getContentId(), externalBlock.getContentType(), this.externalBlocks.get(externalBlock.getContentId()).getContentType()}));
        }
        this.externalBlocks.put(externalBlock.getContentId(), externalBlock);
    }
}

