/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure.block;

import htsjdk.samtools.cram.CRAMException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BlockCompressionMethod {
    RAW(0),
    GZIP(1),
    BZIP2(2),
    LZMA(3),
    RANS(4);

    private final int methodId;
    private static final Map<Integer, BlockCompressionMethod> ID_MAP;

    private BlockCompressionMethod(int id) {
        this.methodId = id;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public static BlockCompressionMethod byId(int id) {
        return Optional.ofNullable(ID_MAP.get(id)).orElseThrow(() -> new CRAMException("Could not find BlockCompressionMethod for: " + id));
    }

    static {
        ID_MAP = Collections.unmodifiableMap(Stream.of(BlockCompressionMethod.values()).collect(Collectors.toMap(BlockCompressionMethod::getMethodId, Function.identity())));
    }
}

