/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekIterator;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.StringUtil;
import htsjdk.samtools.util.TempStreamFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class SortingCollection<T>
implements Iterable<T> {
    private static final Log log = Log.getInstance(SortingCollection.class);
    private final Path[] tmpDirs;
    private final Codec<T> codec;
    private final Comparator<T> comparator;
    private final int maxRecordsInRam;
    private int numRecordsInRam = 0;
    private T[] ramRecords;
    private boolean iterationStarted = false;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<Path> files = new ArrayList<Path>();
    private boolean destructiveIteration = true;
    private final TempStreamFactory tempStreamFactory = new TempStreamFactory();
    private final boolean printRecordSizeSampling;

    private SortingCollection(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRam, boolean printRecordSizeSampling, Path ... tmpDir) {
        if (maxRecordsInRam <= 0) {
            throw new IllegalArgumentException("maxRecordsInRam must be > 0");
        }
        if (tmpDir == null || tmpDir.length == 0) {
            throw new IllegalArgumentException("At least one temp directory must be provided.");
        }
        this.tmpDirs = tmpDir;
        this.codec = codec;
        this.comparator = comparator;
        this.maxRecordsInRam = maxRecordsInRam;
        Object[] ramRecords = (Object[])Array.newInstance(componentType, maxRecordsInRam);
        this.ramRecords = ramRecords;
        this.printRecordSizeSampling = printRecordSizeSampling;
    }

    public void add(T rec) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAdding()");
        }
        if (this.iterationStarted) {
            throw new IllegalStateException("Cannot add after calling iterator()");
        }
        if (this.numRecordsInRam == this.maxRecordsInRam) {
            long startMem = 0L;
            if (this.printRecordSizeSampling) {
                Runtime.getRuntime().gc();
                startMem = Runtime.getRuntime().freeMemory();
            }
            this.spillToDisk();
            if (this.printRecordSizeSampling) {
                Runtime.getRuntime().gc();
                long endMem = Runtime.getRuntime().freeMemory();
                long usedBytes = endMem - startMem;
                log.debug(String.format("%d records in ram required approximately %s memory or %s per record. ", this.maxRecordsInRam, StringUtil.humanReadableByteCount(usedBytes), StringUtil.humanReadableByteCount(usedBytes / (long)this.maxRecordsInRam)));
            }
        }
        this.ramRecords[this.numRecordsInRam++] = rec;
    }

    public void doneAdding() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call doneAdding() after cleanup() was called.");
        }
        if (this.doneAdding) {
            return;
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            return;
        }
        if (this.numRecordsInRam > 0) {
            this.spillToDisk();
        }
        this.ramRecords = null;
    }

    public boolean isDestructiveIteration() {
        return this.destructiveIteration;
    }

    public void setDestructiveIteration(boolean destructiveIteration) {
        this.destructiveIteration = destructiveIteration;
    }

    public void spillToDisk() {
        try {
            Arrays.parallelSort(this.ramRecords, 0, this.numRecordsInRam, this.comparator);
            Path f = this.newTempFile();
            try (OutputStream os = this.tempStreamFactory.wrapTempOutputStream(Files.newOutputStream(f, new OpenOption[0]), Defaults.BUFFER_SIZE);){
                this.codec.setOutputStream(os);
                for (int i = 0; i < this.numRecordsInRam; ++i) {
                    this.codec.encode(this.ramRecords[i]);
                    this.ramRecords[i] = null;
                }
                os.flush();
            }
            catch (RuntimeIOException ex) {
                throw new RuntimeIOException("Problem writing temporary file " + f.toUri() + ".  Try setting TMP_DIR to a file system with lots of space.", ex);
            }
            this.numRecordsInRam = 0;
            this.files.add(f);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private Path newTempFile() throws IOException {
        return IOUtil.newTempPath("sortingcollection.", ".tmp", this.tmpDirs, 0x140000000L);
    }

    @Override
    public CloseableIterator<T> iterator() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call iterator() after cleanup() was called.");
        }
        this.doneAdding();
        this.iterationStarted = true;
        if (this.files.isEmpty()) {
            return new InMemoryIterator();
        }
        return new MergingIterator();
    }

    public void cleanup() {
        this.iterationStarted = true;
        this.cleanedUp = true;
        IOUtil.deletePaths(this.files);
    }

    @Deprecated
    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, File ... tmpDir) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, false, (Path[])Arrays.stream(tmpDir).map(File::toPath).toArray(Path[]::new));
    }

    @Deprecated
    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, Collection<File> tmpDirs) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, false, (Path[])tmpDirs.stream().map(File::toPath).toArray(Path[]::new));
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, boolean printRecordSizeSampling) {
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, printRecordSizeSampling, tmpDir);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, boolean printRecordSizeSampling, Path ... tmpDir) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, printRecordSizeSampling, tmpDir);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM) {
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, false, tmpDir);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, Path ... tmpDir) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, false, tmpDir);
    }

    public static <T> SortingCollection<T> newInstanceFromPaths(Class<T> componentType, Codec<T> codec, Comparator<T> comparator, int maxRecordsInRAM, Collection<Path> tmpDirs) {
        return new SortingCollection<T>(componentType, codec, comparator, maxRecordsInRAM, false, tmpDirs.toArray(new Path[tmpDirs.size()]));
    }

    class PeekFileRecordIteratorComparator
    implements Comparator<PeekFileRecordIterator> {
        PeekFileRecordIteratorComparator() {
        }

        @Override
        public int compare(PeekFileRecordIterator lhs, PeekFileRecordIterator rhs) {
            int result = SortingCollection.this.comparator.compare(lhs.peek(), rhs.peek());
            if (result == 0) {
                return lhs.n - rhs.n;
            }
            return result;
        }
    }

    class PeekFileRecordIterator
    extends PeekIterator<T> {
        final int n;

        PeekFileRecordIterator(Iterator<T> underlyingIterator, int n) {
            super(underlyingIterator);
            this.n = n;
        }
    }

    class FileRecordIterator
    implements CloseableIterator<T> {
        private final Path file;
        private final InputStream is;
        private final Codec<T> codec;
        private T currentRecord = null;

        FileRecordIterator(Path file, int bufferSize) {
            this.file = file;
            try {
                this.is = Files.newInputStream(file, new OpenOption[0]);
                this.codec = SortingCollection.this.codec.clone();
                this.codec.setInputStream(SortingCollection.this.tempStreamFactory.wrapTempInputStream(this.is, bufferSize));
                this.advance();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentRecord;
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.currentRecord = this.codec.decode();
        }

        @Override
        public void close() {
            CloserUtil.close(this.is);
        }
    }

    class MergingIterator
    implements CloseableIterator<T> {
        private final TreeSet<PeekFileRecordIterator> queue;

        MergingIterator() {
            this.queue = new TreeSet<PeekFileRecordIterator>(new PeekFileRecordIteratorComparator());
            int n = 0;
            log.debug(String.format("Creating merging iterator from %d files", SortingCollection.this.files.size()));
            int suggestedBufferSize = this.checkMemoryAndAdjustBuffer(SortingCollection.this.files.size());
            for (Path f : SortingCollection.this.files) {
                FileRecordIterator it = new FileRecordIterator(f, suggestedBufferSize);
                if (it.hasNext()) {
                    this.queue.add(new PeekFileRecordIterator(it, n++));
                    continue;
                }
                it.close();
            }
        }

        private int checkMemoryAndAdjustBuffer(int numFiles) {
            int bufferSize = Defaults.BUFFER_SIZE;
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            long allocatableMemory = rt.freeMemory() + (rt.maxMemory() - rt.totalMemory());
            long freeMemory = allocatableMemory - (long)(numFiles * 20 * 1024);
            int memoryPerFile = (int)(freeMemory / (long)numFiles);
            if (memoryPerFile < 0) {
                log.warn("There is not enough memory per file for buffering. Reading will be unbuffered.");
                bufferSize = 0;
            } else if (bufferSize > memoryPerFile) {
                log.warn(String.format("Default io buffer size of %s is larger than available memory per file of %s.", StringUtil.humanReadableByteCount(bufferSize), StringUtil.humanReadableByteCount(memoryPerFile)));
                bufferSize = memoryPerFile;
            }
            return bufferSize;
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PeekFileRecordIterator fileIterator = this.queue.pollFirst();
            Object ret = fileIterator.next();
            if (fileIterator.hasNext()) {
                this.queue.add(fileIterator);
            } else {
                ((CloseableIterator)fileIterator.getUnderlyingIterator()).close();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            while (!this.queue.isEmpty()) {
                PeekFileRecordIterator it = this.queue.pollFirst();
                ((CloseableIterator)it.getUnderlyingIterator()).close();
            }
        }
    }

    class InMemoryIterator
    implements CloseableIterator<T> {
        private int iterationIndex = 0;

        InMemoryIterator() {
            Arrays.parallelSort(SortingCollection.this.ramRecords, 0, SortingCollection.this.numRecordsInRam, SortingCollection.this.comparator);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterationIndex < SortingCollection.this.numRecordsInRam;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = SortingCollection.this.ramRecords[this.iterationIndex];
            if (SortingCollection.this.destructiveIteration) {
                ((SortingCollection)SortingCollection.this).ramRecords[this.iterationIndex] = null;
            }
            ++this.iterationIndex;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Codec<T>
    extends Cloneable {
        public void setOutputStream(OutputStream var1);

        public void setInputStream(InputStream var1);

        public void encode(T var1);

        public T decode();

        public Codec<T> clone();
    }
}

