/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.resource;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.HostnameValidator;

@SdkInternalApi
public final class S3OutpostAccessPointBuilder {
    private String accessPointName;
    private String outpostId;
    private String region;
    private String accountId;
    private String protocol;
    private String domain;

    private S3OutpostAccessPointBuilder() {
    }

    public static S3OutpostAccessPointBuilder create() {
        return new S3OutpostAccessPointBuilder();
    }

    public S3OutpostAccessPointBuilder accessPointName(String accessPointName) {
        this.accessPointName = accessPointName;
        return this;
    }

    public S3OutpostAccessPointBuilder region(String region) {
        this.region = region;
        return this;
    }

    public S3OutpostAccessPointBuilder accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public S3OutpostAccessPointBuilder outpostId(String outpostId) {
        this.outpostId = outpostId;
        return this;
    }

    public S3OutpostAccessPointBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public S3OutpostAccessPointBuilder domain(String domain) {
        this.domain = domain;
        return this;
    }

    public URI toUri() {
        HostnameValidator.validateHostnameCompliant((String)this.outpostId, (String)"outpostId", (String)"outpost ARN");
        HostnameValidator.validateHostnameCompliant((String)this.accountId, (String)"accountId", (String)"outpost ARN");
        HostnameValidator.validateHostnameCompliant((String)this.accessPointName, (String)"accessPointName", (String)"outpost ARN");
        String uriString = String.format("%s://%s-%s.%s.s3-outposts.%s.%s", this.protocol, this.accessPointName, this.accountId, this.outpostId, this.region, this.domain);
        return URI.create(uriString);
    }
}

