/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2011-2019 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "uniform.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace distributionModels
{
    defineTypeNameAndDebug(uniform, 0);
    addToRunTimeSelectionTable(distributionModel, uniform, dictionary);
}
}

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::distributionModels::uniform::uniform
(
    const dictionary& dict,
    Random& rndGen
)
:
    distributionModel(typeName, dict, rndGen),
    minValue_(distributionModelDict_.template lookup<scalar>("minValue")),
    maxValue_(distributionModelDict_.template lookup<scalar>("maxValue"))
{
    check();
    info();
}


Foam::distributionModels::uniform::uniform(const uniform& p)
:
    distributionModel(p),
    minValue_(p.minValue_),
    maxValue_(p.maxValue_)
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::distributionModels::uniform::~uniform()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::scalar Foam::distributionModels::uniform::sample() const
{
    return rndGen_.scalarAB(minValue_, maxValue_);
}


Foam::scalar Foam::distributionModels::uniform::minValue() const
{
    return minValue_;
}


Foam::scalar Foam::distributionModels::uniform::maxValue() const
{
    return maxValue_;
}


Foam::scalar Foam::distributionModels::uniform::meanValue() const
{
    return 0.5*(minValue_ + maxValue_);
}


// ************************************************************************* //
