/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2019-2020 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::specieTransferVelocityFvPatchVectorField

Description
    This is a velocity boundary condition for a specie-transferring wall.

    This condition must be used in conjunction with mass-fraction boundary
    conditions derived from specieTransferMassFractionFvPatchScalarField, and a
    specieTransferTemperature condition for the temperature.

    This condition sums the species' mass fluxes generated by the
    mass-fraction conditions, and uses this total to set the normal velocity
    into or out of the wall.

Usage
    \table
        Property | Description               | Req'd? | Default
        rho      | Name of the density field | no     | rho
    \endtable

    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        type            specieTransferVelocity;
        value           $internalField;
    }
    \endverbatim

See also
    Foam::specieTransferMassFractionFvPatchScalarField
    Foam::specieTransferTemperatureFvPatchScalarField

SourceFiles
    specieTransferVelocityFvPatchVectorField.C

\*---------------------------------------------------------------------------*/

#ifndef specieTransferVelocityFvPatchVectorField_H
#define specieTransferVelocityFvPatchVectorField_H

#include "fixedValueFvPatchFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
          Class specieTransferVelocityFvPatchVectorField Declaration
\*---------------------------------------------------------------------------*/

class specieTransferVelocityFvPatchVectorField
:
    public fixedValueFvPatchVectorField
{
    // Private Data

        //- Name of the density field
        const word rhoName_;


public:

    //- Runtime type information
    TypeName("specieTransferVelocity");


    // Constructors

        //- Construct from patch and internal field
        specieTransferVelocityFvPatchVectorField
        (
            const fvPatch&,
            const DimensionedField<vector, volMesh>&
        );

        //- Construct from patch, internal field and dictionary
        specieTransferVelocityFvPatchVectorField
        (
            const fvPatch&,
            const DimensionedField<vector, volMesh>&,
            const dictionary&,
            const bool readValue = true
        );

        //- Construct by mapping given fixedValueTypeFvPatchField
        //  onto a new patch
        specieTransferVelocityFvPatchVectorField
        (
            const specieTransferVelocityFvPatchVectorField&,
            const fvPatch&,
            const DimensionedField<vector, volMesh>&,
            const fvPatchFieldMapper&
        );

        //- Disallow copy without setting internal field reference
        specieTransferVelocityFvPatchVectorField
        (
            const specieTransferVelocityFvPatchVectorField&
        ) = delete;

        //- Copy constructor setting internal field reference
        specieTransferVelocityFvPatchVectorField
        (
            const specieTransferVelocityFvPatchVectorField&,
            const DimensionedField<vector, volMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchVectorField> clone
        (
            const DimensionedField<vector, volMesh>& iF
        ) const
        {
            return tmp<fvPatchVectorField>
            (
                new specieTransferVelocityFvPatchVectorField
                (
                    *this,
                    iF
                )
            );
        }


    // Member Functions

        // Evaluation functions

            //- Return the flux
            const tmp<scalarField> phip() const;

            //- Update the coefficients associated with the patch field
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //


#endif

// ************************************************************************* //
