/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BAMQueryMultipleIntervalsIteratorFilter;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.CRAMIterator;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.SamIndexes;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class CRAMFileReader
extends SamReader.ReaderImplementation
implements SamReader.Indexing,
AutoCloseable {
    private File cramFile;
    private final CRAMReferenceSource referenceSource;
    private InputStream inputStream;
    private CRAMIterator iterator;
    private BAMIndex mIndex;
    private File mIndexFile;
    private boolean mEnableIndexCaching;
    private boolean mEnableIndexMemoryMapping;
    private ValidationStringency validationStringency;
    private static final Log log = Log.getInstance(CRAMFileReader.class);
    private static final SAMRecordIterator emptyIterator = new SAMRecordIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new RuntimeException("No records.");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported.");
        }

        @Override
        public void close() {
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return this;
        }
    };

    public CRAMFileReader(File cramFile, InputStream inputStream) {
        this(cramFile, inputStream, ReferenceSource.getDefaultCRAMReferenceSource());
    }

    public CRAMFileReader(File cramFile, InputStream inputStream, CRAMReferenceSource referenceSource) {
        if (cramFile == null && inputStream == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM readers");
        }
        this.cramFile = cramFile;
        this.inputStream = inputStream;
        this.referenceSource = referenceSource;
        if (cramFile != null) {
            this.mIndexFile = this.findIndexForFile(null, cramFile);
        }
        this.getIterator();
    }

    public CRAMFileReader(File cramFile, File indexFile, CRAMReferenceSource referenceSource) {
        if (cramFile == null) {
            throw new IllegalArgumentException("File is required.");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM readers");
        }
        this.cramFile = cramFile;
        this.mIndexFile = this.findIndexForFile(indexFile, cramFile);
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File cramFile, CRAMReferenceSource referenceSource) {
        if (cramFile == null) {
            throw new IllegalArgumentException("CRAM file cannot be null.");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM readers");
        }
        this.cramFile = cramFile;
        this.referenceSource = referenceSource;
        this.mIndexFile = this.findIndexForFile(null, cramFile);
        this.getIterator();
    }

    public CRAMFileReader(InputStream inputStream, SeekableStream indexInputStream, CRAMReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream can not be null for CRAM reader");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM readers");
        }
        this.referenceSource = referenceSource;
        this.initWithStreams(inputStream, indexInputStream, validationStringency);
    }

    public CRAMFileReader(InputStream stream, File indexFile, CRAMReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        this(stream, indexFile == null ? null : new SeekableFileStream(indexFile), referenceSource, validationStringency);
    }

    public CRAMFileReader(File cramFile, File indexFile, CRAMReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        if (cramFile == null) {
            throw new IllegalArgumentException("Input file can not be null for CRAM reader");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM readers");
        }
        this.cramFile = cramFile;
        this.referenceSource = referenceSource;
        this.mIndexFile = this.findIndexForFile(indexFile, cramFile);
        SeekableFileStream indexStream = this.mIndexFile == null ? null : new SeekableFileStream(this.mIndexFile);
        this.initWithStreams(new FileInputStream(cramFile), indexStream, validationStringency);
    }

    private void initWithStreams(InputStream inputStream, SeekableStream indexInputStream, ValidationStringency validationStringency) throws IOException {
        this.inputStream = inputStream;
        this.validationStringency = validationStringency;
        this.iterator = new CRAMIterator(inputStream, this.referenceSource, validationStringency);
        if (indexInputStream != null) {
            SeekableStream baiStream = SamIndexes.asBaiSeekableStreamOrNull(indexInputStream, this.iterator.getSAMFileHeader().getSequenceDictionary());
            if (null != baiStream) {
                this.mIndex = new CachingBAMFileIndex(baiStream, this.iterator.getSAMFileHeader().getSequenceDictionary());
            } else {
                throw new IllegalArgumentException("CRAM index must be a BAI or CRAI stream");
            }
        }
    }

    private File findIndexForFile(File indexFile, File cramFile) {
        File file = indexFile = indexFile == null ? SamFiles.findIndex(cramFile) : indexFile;
        if (indexFile != null && indexFile.lastModified() < cramFile.lastModified()) {
            log.warn("CRAM index file " + indexFile.getAbsolutePath() + " is older than CRAM " + cramFile.getAbsolutePath());
        }
        return indexFile;
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        this.mEnableIndexCaching = enabled;
    }

    @Override
    void enableIndexMemoryMapping(boolean enabled) {
        this.mEnableIndexMemoryMapping = enabled;
    }

    @Override
    void enableCrcChecking(boolean enabled) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory factory) {
    }

    @Override
    public boolean hasIndex() {
        return this.mIndex != null || this.mIndexFile != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this CRAM file.");
        }
        if (this.mIndex == null) {
            SeekableStream baiStream;
            SAMSequenceDictionary dictionary = this.getFileHeader().getSequenceDictionary();
            if (this.mIndexFile.getName().endsWith(".bai")) {
                this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, dictionary, this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, dictionary, this.mEnableIndexMemoryMapping);
                return this.mIndex;
            }
            if (!this.mIndexFile.getName().endsWith(".crai")) {
                return null;
            }
            try {
                baiStream = SamIndexes.asBaiSeekableStreamOrNull(new SeekableFileStream(this.mIndexFile), this.iterator.getSAMFileHeader().getSequenceDictionary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(baiStream, this.getFileHeader().getSequenceDictionary()) : new DiskBasedBAMFileIndex(baiStream, this.getFileHeader().getSequenceDictionary());
        }
        return this.mIndex;
    }

    @Override
    public boolean hasBrowseableIndex() {
        return false;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        return null;
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan fileSpan) {
        long[] coordinateArray = ((BAMFileSpan)fileSpan).toCoordinateArray();
        if (coordinateArray == null || coordinateArray.length == 0) {
            return emptyIterator;
        }
        SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
        return new CRAMIterator(seekableStream, this.referenceSource, coordinateArray, this.validationStringency);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.iterator.getSAMFileHeader();
    }

    public SAMRecordIterator getIterator() {
        if (this.iterator != null && this.cramFile == null) {
            return this.iterator;
        }
        try {
            CRAMIterator newIterator = this.cramFile != null ? new CRAMIterator(new FileInputStream(this.cramFile), this.referenceSource, this.validationStringency) : new CRAMIterator(this.inputStream, this.referenceSource, this.validationStringency);
            this.iterator = newIterator;
            return this.iterator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan fileSpan) {
        return this.iterator(fileSpan);
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.iterator.firstContainerOffset << 16, Long.MAX_VALUE));
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        SAMFileHeader fileHeader = this.getFileHeader();
        int referenceIndex = fileHeader.getSequenceIndex(sequence);
        return new CRAMIntervalIterator(new QueryInterval[]{new QueryInterval(referenceIndex, start, -1)}, true);
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        long startOfLastLinearBin = this.getIndex().getStartOfLastLinearBin();
        SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
        try {
            boolean atAlignments;
            seekableStream.seek(0L);
            CRAMIterator newIterator = new CRAMIterator((InputStream)seekableStream, this.referenceSource, this.validationStringency);
            seekableStream.seek(startOfLastLinearBin >>> 16);
            Container container = ContainerIO.readContainerHeader(newIterator.getCramHeader().getVersion().major, seekableStream);
            seekableStream.seek(seekableStream.position() + (long)container.containerByteSize);
            this.iterator = newIterator;
            while (!(atAlignments = this.iterator.advanceToAlignmentInContainer(-1, 0)) && this.iterator.hasNext()) {
            }
        }
        catch (IOException e) {
            throw new RuntimeEOFException(e);
        }
        return this.iterator;
    }

    private SeekableStream getSeekableStreamOrFailWithRTE() {
        SeekableStream seekableStream = null;
        if (this.cramFile != null) {
            try {
                seekableStream = new SeekableFileStream(this.cramFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else if (this.inputStream instanceof SeekableStream) {
            seekableStream = (SeekableStream)this.inputStream;
        }
        return seekableStream;
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
        CloserUtil.close(this.inputStream);
        CloserUtil.close(this.mIndex);
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
        if (this.iterator != null) {
            this.iterator.setValidationStringency(validationStringency);
        }
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] intervals, boolean contained) {
        return new CRAMIntervalIterator(intervals, contained);
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.CRAM_TYPE;
    }

    @Override
    void enableFileSource(SamReader reader, boolean enabled) {
        if (this.iterator != null) {
            this.iterator.setFileSource(enabled ? reader : null);
        }
    }

    public CloseableIterator<SAMRecord> createIndexIterator(QueryInterval[] intervals, boolean contained, long[] filePointers) {
        return new CRAMIntervalIterator(intervals, contained, filePointers);
    }

    private static long[] coordinatesFromQueryIntervals(BAMIndex index, QueryInterval[] queries) {
        ArrayList spanList = new ArrayList(1);
        Arrays.asList(queries).forEach(qi -> spanList.add(index.getSpanOverlapping(qi.referenceIndex, qi.start, qi.end)));
        BAMFileSpan[] spanArray = new BAMFileSpan[spanList.size()];
        for (int i = 0; i < spanList.size(); ++i) {
            spanArray[i] = (BAMFileSpan)spanList.get(i);
        }
        return BAMFileSpan.merge(spanArray).toCoordinateArray();
    }

    private class CRAMIntervalIterator
    extends BAMQueryMultipleIntervalsIteratorFilter
    implements CloseableIterator<SAMRecord> {
        private CRAMIterator unfilteredIterator;
        SAMRecord nextRec;

        public CRAMIntervalIterator(QueryInterval[] queries, boolean contained) {
            this(queries, contained, CRAMFileReader.coordinatesFromQueryIntervals(cRAMFileReader.getIndex(), queries));
        }

        public CRAMIntervalIterator(QueryInterval[] queries, boolean contained, long[] coordinates) {
            super(queries, contained);
            this.nextRec = null;
            if (coordinates != null && coordinates.length != 0) {
                this.unfilteredIterator = new CRAMIterator(CRAMFileReader.this.getSeekableStreamOrFailWithRTE(), CRAMFileReader.this.referenceSource, coordinates, CRAMFileReader.this.validationStringency);
                this.getNextRecord();
            }
        }

        @Override
        public void close() {
            if (this.unfilteredIterator != null) {
                this.unfilteredIterator.close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextRec != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Next called on empty CRAMIntervalIterator");
            }
            return this.getNextRecord();
        }

        private SAMRecord getNextRecord() {
            SAMRecord result = this.nextRec;
            this.nextRec = null;
            block5: while (this.nextRec == null && this.unfilteredIterator.hasNext()) {
                SAMRecord nextRecord = this.unfilteredIterator.next();
                switch (this.compareToFilter(nextRecord)) {
                    case MATCHES_FILTER: {
                        this.nextRec = nextRecord;
                        continue block5;
                    }
                    case CONTINUE_ITERATION: {
                        continue block5;
                    }
                    case STOP_ITERATION: {
                        continue block5;
                    }
                }
                throw new SAMException("Unexpected return from compareToFilter");
            }
            return result;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Method \"remove\" not implemented for CRAMIntervalIterator.");
        }
    }
}

