/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.CRAMBAIIndexer;
import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableMemoryStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CRAIIndex {
    public static final String CRAI_INDEX_SUFFIX = ".crai";
    private final List<CRAIEntry> entries = new ArrayList<CRAIEntry>();

    public void addEntry(CRAIEntry entry) {
        this.entries.add(entry);
    }

    public List<CRAIEntry> getCRAIEntries() {
        return this.entries;
    }

    public void writeIndex(OutputStream os) {
        Collections.sort(this.entries, CRAIEntry.byStartDesc);
        this.entries.stream().forEach(e -> e.writeToStream(os));
    }

    public void processContainer(Container container) {
        if (!container.isEOF()) {
            for (Slice s : container.slices) {
                if (s.getReferenceContext().isMultiRef()) {
                    Map<ReferenceContext, AlignmentSpan> spans = s.getMultiRefAlignmentSpans(container.header, ValidationStringency.DEFAULT_STRINGENCY);
                    this.entries.addAll(spans.entrySet().stream().map(e -> new CRAIEntry(((ReferenceContext)e.getKey()).getSequenceId(), ((AlignmentSpan)e.getValue()).getStart(), ((AlignmentSpan)e.getValue()).getSpan(), container.offset, container.landmarks[s.index], s.size)).collect(Collectors.toList()));
                    continue;
                }
                this.entries.add(s.getCRAIEntry(container.offset));
            }
        }
    }

    public static SeekableStream openCraiFileAsBaiStream(File cramIndexFile, SAMSequenceDictionary dictionary) {
        try {
            return CRAIIndex.openCraiFileAsBaiStream(new FileInputStream(cramIndexFile), dictionary);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static SeekableStream openCraiFileAsBaiStream(InputStream indexStream, SAMSequenceDictionary dictionary) {
        List<CRAIEntry> full = CRAMCRAIIndexer.readIndex(indexStream).getCRAIEntries();
        Collections.sort(full);
        SAMFileHeader header = new SAMFileHeader();
        header.setSequenceDictionary(dictionary);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRAMBAIIndexer indexer = new CRAMBAIIndexer(baos, header);
        for (CRAIEntry entry : full) {
            Slice slice = new Slice(new ReferenceContext(entry.getSequenceId()));
            slice.containerOffset = entry.getContainerStartByteOffset();
            slice.alignmentStart = entry.getAlignmentStart();
            slice.alignmentSpan = entry.getAlignmentSpan();
            slice.offset = entry.getSliceByteOffset();
            slice.nofRecords = 0;
            slice.index = 0;
            indexer.processSingleReferenceSlice(slice);
        }
        indexer.finish();
        return new SeekableMemoryStream(baos.toByteArray(), "CRAI to BAI converter");
    }

    public static List<CRAIEntry> find(List<CRAIEntry> list, int seqId, int start, int span) {
        boolean whole = start < 1 || span < 1;
        CRAIEntry query = new CRAIEntry(seqId, start < 1 ? 1 : start, span < 1 ? Integer.MAX_VALUE : span, Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        ArrayList<CRAIEntry> l = new ArrayList<CRAIEntry>();
        for (CRAIEntry e : list) {
            if (e.getSequenceId() != seqId || !whole && !CRAIEntry.intersect(e, query)) continue;
            l.add(e);
        }
        Collections.sort(l, CRAIEntry.byStart);
        return l;
    }

    public static CRAIEntry getLeftmost(List<CRAIEntry> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        CRAIEntry left = list.get(0);
        for (CRAIEntry e : list) {
            if (e.getAlignmentStart() >= left.getAlignmentStart()) continue;
            left = e;
        }
        return left;
    }

    public static int findLastAlignedEntry(List<CRAIEntry> list) {
        if (list.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CRAIEntry midVal = list.get(mid);
            if (midVal.getSequenceId() >= 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (low >= list.size()) {
            return list.size() - 1;
        }
        while (low >= 0 && list.get(low).getSequenceId() == -1) {
            --low;
        }
        return low;
    }

    public static class CRAIIndexException
    extends RuntimeException {
        public CRAIIndexException(String s) {
            super(s);
        }

        public CRAIIndexException(NumberFormatException e) {
            super(e);
        }
    }
}

