/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import java.util.ArrayList;
import java.util.List;

public class ContainerFactory {
    private final SAMFileHeader samFileHeader;
    private int recordsPerSlice = 10000;
    private boolean preserveReadNames = true;
    private long globalRecordCounter = 0L;

    public ContainerFactory(SAMFileHeader samFileHeader, int recordsPerSlice) {
        this.samFileHeader = samFileHeader;
        this.recordsPerSlice = recordsPerSlice;
    }

    public Container buildContainer(List<CramCompressionRecord> records) {
        boolean coordinateSorted = this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate;
        CompressionHeader header = new CompressionHeaderFactory().build(records, null, coordinateSorted);
        header.readNamesIncluded = this.preserveReadNames;
        ArrayList<Slice> slices = new ArrayList<Slice>();
        int baseCount = 0;
        long lastGlobalRecordCounter = this.globalRecordCounter;
        for (int i = 0; i < records.size(); i += this.recordsPerSlice) {
            List<CramCompressionRecord> sliceRecords = records.subList(i, Math.min(records.size(), i + this.recordsPerSlice));
            Slice slice = Slice.buildSlice(sliceRecords, header);
            slice.globalRecordCounter = this.globalRecordCounter;
            this.globalRecordCounter += (long)slice.nofRecords;
            baseCount = (int)((long)baseCount + slice.bases);
            slices.add(slice);
        }
        Container container = Container.initializeFromSlices(slices);
        container.header = header;
        container.nofRecords = records.size();
        container.globalRecordCounter = lastGlobalRecordCounter;
        container.blockCount = 0;
        container.bases += (long)baseCount;
        return container;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }
}

