/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerParser {
    private final SAMFileHeader samFileHeader;

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records, ValidationStringency validationStringency) {
        if (container.isEOF()) {
            return Collections.emptyList();
        }
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice slice : container.slices) {
            records.addAll(this.getRecords(slice, container.header, validationStringency));
        }
        return records;
    }

    public Map<ReferenceContext, AlignmentSpan> getReferences(Container container, ValidationStringency validationStringency) {
        HashMap<ReferenceContext, AlignmentSpan> containerSpanMap = new HashMap<ReferenceContext, AlignmentSpan>();
        for (Slice slice : container.slices) {
            ContainerParser.addAllSpans(containerSpanMap, this.getReferences(slice, container.header, validationStringency));
        }
        return containerSpanMap;
    }

    private static void addSpan(ReferenceContext refContext, int start, int span, int count, Map<ReferenceContext, AlignmentSpan> map) {
        if (map.containsKey(refContext)) {
            map.get(refContext).add(start, span, count);
        } else {
            map.put(refContext, new AlignmentSpan(start, span, count));
        }
    }

    private static Map<ReferenceContext, AlignmentSpan> addAllSpans(Map<ReferenceContext, AlignmentSpan> spanMap, Map<ReferenceContext, AlignmentSpan> addition) {
        for (Map.Entry<ReferenceContext, AlignmentSpan> entry : addition.entrySet()) {
            ContainerParser.addSpan(entry.getKey(), entry.getValue().getStart(), entry.getValue().getSpan(), entry.getValue().getCount(), spanMap);
        }
        return spanMap;
    }

    private Map<ReferenceContext, AlignmentSpan> getReferences(Slice slice, CompressionHeader header, ValidationStringency validationStringency) {
        HashMap<ReferenceContext, AlignmentSpan> spanMap = new HashMap<ReferenceContext, AlignmentSpan>();
        ReferenceContext sliceContext = slice.getReferenceContext();
        switch (sliceContext.getType()) {
            case UNMAPPED_UNPLACED_TYPE: {
                spanMap.put(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, AlignmentSpan.UNMAPPED_SPAN);
                break;
            }
            case MULTIPLE_REFERENCE_TYPE: {
                Map<ReferenceContext, AlignmentSpan> spans = slice.getMultiRefAlignmentSpans(header, validationStringency);
                ContainerParser.addAllSpans(spanMap, spans);
                break;
            }
            default: {
                ContainerParser.addSpan(sliceContext, slice.alignmentStart, slice.alignmentSpan, slice.nofRecords, spanMap);
            }
        }
        return spanMap;
    }

    private ArrayList<CramCompressionRecord> getRecords(Slice slice, CompressionHeader header, ValidationStringency validationStringency) {
        ReferenceContext sliceContext = slice.getReferenceContext();
        String seqName = "*";
        if (sliceContext.isMappedSingleRef()) {
            SAMSequenceRecord sequence = this.samFileHeader.getSequence(sliceContext.getSequenceId());
            seqName = sequence.getSequenceName();
        }
        CramRecordReader reader = slice.createCramRecordReader(header, validationStringency);
        ArrayList<CramCompressionRecord> records = new ArrayList<CramCompressionRecord>(slice.nofRecords);
        int prevAlignmentStart = slice.alignmentStart;
        for (int i = 0; i < slice.nofRecords; ++i) {
            CramCompressionRecord record = new CramCompressionRecord();
            record.sliceIndex = slice.index;
            record.index = i;
            prevAlignmentStart = reader.read(record, prevAlignmentStart);
            record.sequenceName = sliceContext.isMappedSingleRef() && record.sequenceId == sliceContext.getSequenceId() ? seqName : (record.sequenceId == -1 ? "*" : this.samFileHeader.getSequence(record.sequenceId).getSequenceName());
            records.add(record);
        }
        return records;
    }
}

