/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiRefSliceAlignmentSpanReader
extends CramRecordReader {
    private int prevAlignmentStart;
    private final Map<ReferenceContext, AlignmentSpan> spans = new HashMap<ReferenceContext, AlignmentSpan>();

    public MultiRefSliceAlignmentSpanReader(BitInputStream coreInputStream, Map<Integer, ByteArrayInputStream> externalInputMap, CompressionHeader header, ValidationStringency validationStringency, int initialAlignmentStart, int recordCount) {
        super(coreInputStream, externalInputMap, header, ReferenceContext.MULTIPLE_REFERENCE_CONTEXT, validationStringency);
        this.prevAlignmentStart = initialAlignmentStart;
        for (int i = 0; i < recordCount; ++i) {
            this.readCramRecord();
        }
    }

    public Map<ReferenceContext, AlignmentSpan> getReferenceSpans() {
        return Collections.unmodifiableMap(this.spans);
    }

    private void readCramRecord() {
        CramCompressionRecord cramRecord = new CramCompressionRecord();
        this.prevAlignmentStart = super.read(cramRecord, this.prevAlignmentStart);
        ReferenceContext recordContext = new ReferenceContext(cramRecord.sequenceId);
        if (!this.spans.containsKey(recordContext)) {
            this.spans.put(recordContext, new AlignmentSpan(this.prevAlignmentStart, cramRecord.readLength));
        } else {
            this.spans.get(recordContext).addSingle(this.prevAlignmentStart, cramRecord.readLength);
        }
    }
}

