/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.ReferenceRegion;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class InMemoryReferenceSequenceFile
implements ReferenceSequenceFile {
    private Map<Integer, byte[]> sequences = new HashMap<Integer, byte[]>();
    private SAMSequenceDictionary dictionary = new SAMSequenceDictionary();
    private int currentIndex = 0;

    InMemoryReferenceSequenceFile() {
    }

    public void addSequence(String name, byte[] bases) {
        SAMSequenceRecord r = new SAMSequenceRecord(name, bases.length);
        this.dictionary.addSequence(r);
        int index = this.getSequenceDictionary().getSequenceIndex(name);
        this.sequences.put(index, bases);
    }

    @Override
    public ReferenceSequence getSequence(String name) {
        int index = this.getSequenceDictionary().getSequenceIndex(name);
        return new ReferenceSequence(name, index, this.sequences.get(index));
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.dictionary;
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String name, long start, long stop) {
        int index = this.getSequenceDictionary().getSequenceIndex(name);
        byte[] bases = Arrays.copyOfRange(this.sequences.get(index), (int)start, (int)stop + 1);
        return new ReferenceSequence(name, index, bases);
    }

    @Override
    public void close() {
        this.sequences = null;
        this.dictionary = null;
    }

    public ReferenceRegion getRegion(String name, long start, long stop) {
        int index = this.getSequenceDictionary().getSequenceIndex(name);
        if (!this.sequences.containsKey(index)) {
            throw new RuntimeException("Sequence not found: " + name);
        }
        return new ReferenceRegion(this.sequences.get(index), index, name, start, stop);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ReferenceSequence nextSequence() {
        if (this.currentIndex >= this.dictionary.size()) {
            return null;
        }
        SAMSequenceRecord sequence = this.dictionary.getSequence(this.currentIndex++);
        return this.getSequence(sequence.getSequenceName());
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
    }
}

