/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.Log;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CramCompressionRecord {
    private static final int MULTI_FRAGMENT_FLAG = 1;
    private static final int PROPER_PAIR_FLAG = 2;
    private static final int SEGMENT_UNMAPPED_FLAG = 4;
    private static final int NEGATIVE_STRAND_FLAG = 16;
    private static final int FIRST_SEGMENT_FLAG = 64;
    private static final int LAST_SEGMENT_FLAG = 128;
    private static final int SECONDARY_ALIGNMENT_FLAG = 256;
    private static final int VENDOR_FILTERED_FLAG = 512;
    private static final int DUPLICATE_FLAG = 1024;
    private static final int SUPPLEMENTARY_FLAG = 2048;
    private static final int MATE_NEG_STRAND_FLAG = 1;
    private static final int MATE_UNMAPPED_FLAG = 2;
    private static final int FORCE_PRESERVE_QS_FLAG = 1;
    private static final int DETACHED_FLAG = 2;
    private static final int HAS_MATE_DOWNSTREAM_FLAG = 4;
    private static final int UNKNOWN_BASES = 8;
    private static final int UNINITIALIZED_END = -1;
    private static final int UNINITIALIZED_SPAN = -1;
    private static final Log log = Log.getInstance(CramCompressionRecord.class);
    public int index = 0;
    public int alignmentStart;
    private int alignmentEnd = -1;
    private int alignmentSpan = -1;
    public int readLength;
    public int recordsToNextFragment = -1;
    public byte[] readBases;
    public byte[] qualityScores;
    public List<ReadFeature> readFeatures;
    public int readGroupID = 0;
    public int flags = 0;
    public int mateFlags = 0;
    public int compressionFlags = 0;
    public CramCompressionRecord next;
    public CramCompressionRecord previous;
    public int mateSequenceID = -1;
    public int mateAlignmentStart = 0;
    public int mappingQuality;
    public String sequenceName;
    public int sequenceId;
    public String readName;
    public int templateSize;
    public ReadTag[] tags;
    public byte[] tagIds;
    public MutableInt tagIdsIndex;
    public int sliceIndex = 0;

    public byte getMateFlags() {
        return (byte)(0xFF & this.mateFlags);
    }

    public byte getCompressionFlags() {
        return (byte)(0xFF & this.compressionFlags);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CramCompressionRecord)) {
            return false;
        }
        CramCompressionRecord cramRecord = (CramCompressionRecord)obj;
        if (this.alignmentStart != cramRecord.alignmentStart) {
            return false;
        }
        if (this.isNegativeStrand() != cramRecord.isNegativeStrand()) {
            return false;
        }
        if (this.isVendorFiltered() != cramRecord.isVendorFiltered()) {
            return false;
        }
        if (this.isSegmentUnmapped() != cramRecord.isSegmentUnmapped()) {
            return false;
        }
        if (this.readLength != cramRecord.readLength) {
            return false;
        }
        if (this.isLastSegment() != cramRecord.isLastSegment()) {
            return false;
        }
        if (this.recordsToNextFragment != cramRecord.recordsToNextFragment) {
            return false;
        }
        if (this.isFirstSegment() != cramRecord.isFirstSegment()) {
            return false;
        }
        if (this.mappingQuality != cramRecord.mappingQuality) {
            return false;
        }
        if (!this.deepEquals(this.readFeatures, cramRecord.readFeatures)) {
            return false;
        }
        if (!Arrays.equals(this.readBases, cramRecord.readBases)) {
            return false;
        }
        return Arrays.equals(this.qualityScores, cramRecord.qualityScores) && this.areEqual(this.flags, cramRecord.flags) && this.areEqual(this.readName, cramRecord.readName);
    }

    private boolean areEqual(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    private boolean deepEquals(Collection<?> c1, Collection<?> c2) {
        return (c1 == null || c1.isEmpty()) && (c2 == null || c2.isEmpty()) || c1 != null && c1.equals(c2);
    }

    public int hashCode() {
        int result = Objects.hash(this.alignmentStart, this.readLength, this.recordsToNextFragment, this.mappingQuality, this.flags, this.readName);
        if (this.readFeatures != null && !this.readFeatures.isEmpty()) {
            result = 31 * result + Objects.hash(this.readFeatures);
        }
        result = 31 * result + Arrays.hashCode(this.readBases);
        result = 31 * result + Arrays.hashCode(this.qualityScores);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (this.readName != null) {
            stringBuilder.append(this.readName).append("; ");
        }
        stringBuilder.append("flags=").append(this.flags).append("; alignmentStart=").append(this.alignmentStart).append("; mateOffset=").append(this.recordsToNextFragment).append("; mappingQuality=").append(this.mappingQuality);
        if (this.readFeatures != null) {
            for (ReadFeature feature : this.readFeatures) {
                stringBuilder.append("; ").append(feature.toString());
            }
        }
        if (this.readBases != null) {
            stringBuilder.append("; ").append("bases: ").append(new String(this.readBases));
        }
        if (this.qualityScores != null) {
            stringBuilder.append("; ").append("scores: ").append(new String(this.qualityScores));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int getAlignmentSpan() {
        if (this.alignmentSpan == -1) {
            this.intializeAlignmentBoundaries();
        }
        return this.alignmentSpan;
    }

    public int getAlignmentEnd() {
        if (this.alignmentEnd == -1) {
            this.intializeAlignmentBoundaries();
        }
        return this.alignmentEnd;
    }

    private void intializeAlignmentBoundaries() {
        if (!this.isPlaced()) {
            this.alignmentSpan = 0;
            this.alignmentEnd = 0;
            return;
        }
        this.alignmentSpan = this.readLength;
        if (this.readFeatures != null) {
            for (ReadFeature readFeature : this.readFeatures) {
                switch (readFeature.getOperator()) {
                    case 105: {
                        --this.alignmentSpan;
                        break;
                    }
                    case 73: {
                        this.alignmentSpan -= ((Insertion)readFeature).getSequence().length;
                        break;
                    }
                    case 83: {
                        this.alignmentSpan -= ((SoftClip)readFeature).getSequence().length;
                        break;
                    }
                    case 68: {
                        this.alignmentSpan += ((Deletion)readFeature).getLength();
                        break;
                    }
                }
            }
        }
        this.alignmentEnd = this.alignmentStart + this.alignmentSpan - 1;
    }

    public boolean isMultiFragment() {
        return (this.flags & 1) != 0;
    }

    public void setMultiFragment(boolean multiFragment) {
        this.flags = multiFragment ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public boolean isSegmentUnmapped() {
        return (this.flags & 4) != 0;
    }

    public void setSegmentUnmapped(boolean segmentUnmapped) {
        this.flags = segmentUnmapped ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    boolean isPlaced() {
        boolean placed;
        boolean bl = placed = this.sequenceId != -1 && this.alignmentStart != 0;
        if (!placed && !this.isSegmentUnmapped()) {
            String warning = String.format("Cram Compression Record [%s] does not have the unmapped flag set, but also does not have a valid placement on a reference sequence.", this.toString());
            log.warn(warning);
        }
        return placed;
    }

    public boolean isFirstSegment() {
        return (this.flags & 0x40) != 0;
    }

    public void setFirstSegment(boolean firstSegment) {
        this.flags = firstSegment ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
    }

    public boolean isLastSegment() {
        return (this.flags & 0x80) != 0;
    }

    public void setLastSegment(boolean lastSegment) {
        this.flags = lastSegment ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
    }

    public boolean isSecondaryAlignment() {
        return (this.flags & 0x100) != 0;
    }

    public void setSecondaryAlignment(boolean secondaryAlignment) {
        this.flags = secondaryAlignment ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    public boolean isVendorFiltered() {
        return (this.flags & 0x200) != 0;
    }

    public void setVendorFiltered(boolean vendorFiltered) {
        this.flags = vendorFiltered ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
    }

    public boolean isProperPair() {
        return (this.flags & 2) != 0;
    }

    public void setProperPair(boolean properPair) {
        this.flags = properPair ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public boolean isDuplicate() {
        return (this.flags & 0x400) != 0;
    }

    public void setDuplicate(boolean duplicate) {
        this.flags = duplicate ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
    }

    public boolean isNegativeStrand() {
        return (this.flags & 0x10) != 0;
    }

    public void setNegativeStrand(boolean negativeStrand) {
        this.flags = negativeStrand ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isMateUnmapped() {
        return (this.mateFlags & 2) != 0;
    }

    public void setMateUnmapped(boolean mateUnmapped) {
        this.mateFlags = mateUnmapped ? this.mateFlags | 2 : this.mateFlags & 0xFFFFFFFD;
    }

    public boolean isMateNegativeStrand() {
        return (this.mateFlags & 1) != 0;
    }

    public void setMateNegativeStrand(boolean mateNegativeStrand) {
        this.mateFlags = mateNegativeStrand ? this.mateFlags | 1 : this.mateFlags & 0xFFFFFFFE;
    }

    public boolean isHasMateDownStream() {
        return (this.compressionFlags & 4) != 0;
    }

    public void setHasMateDownStream(boolean hasMateDownStream) {
        this.compressionFlags = hasMateDownStream ? this.compressionFlags | 4 : this.compressionFlags & 0xFFFFFFFB;
    }

    public boolean isDetached() {
        return (this.compressionFlags & 2) != 0;
    }

    public void setDetached(boolean detached) {
        this.compressionFlags = detached ? this.compressionFlags | 2 : this.compressionFlags & 0xFFFFFFFD;
    }

    public boolean isForcePreserveQualityScores() {
        return (this.compressionFlags & 1) != 0;
    }

    public void setForcePreserveQualityScores(boolean forcePreserveQualityScores) {
        this.compressionFlags = forcePreserveQualityScores ? this.compressionFlags | 1 : this.compressionFlags & 0xFFFFFFFE;
    }

    public boolean isUnknownBases() {
        return (this.compressionFlags & 8) != 0;
    }

    public void setUnknownBases(boolean unknownBases) {
        this.compressionFlags = unknownBases ? this.compressionFlags | 8 : this.compressionFlags & 0xFFFFFFF7;
    }

    public boolean isSupplementary() {
        return (this.flags & 0x800) != 0;
    }

    public void setSupplementary(boolean supplementary) {
        this.flags = supplementary ? this.flags | 0x800 : this.flags & 0xFFFFF7FF;
    }
}

