/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.reference.FastaReferenceWriter;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.utils.ValidationUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FastaReferenceWriterBuilder {
    private Path fastaFile;
    private boolean makeFaiOutput = true;
    private boolean makeDictOutput = true;
    private boolean emitMd5 = true;
    private int basesPerLine = 60;
    private Path indexFile;
    private Path dictFile;
    private OutputStream fastaOutput;
    private OutputStream indexOutput;
    private OutputStream dictOutput;

    private static Path defaultFaiFile(boolean makeFaiFile, Path fastaFile) {
        return makeFaiFile ? ReferenceSequenceFileFactory.getFastaIndexFileName(fastaFile) : null;
    }

    private static Path defaultDictFile(boolean makeDictFile, Path fastaFile) {
        return makeDictFile ? ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(fastaFile) : null;
    }

    protected static int checkBasesPerLine(int value) {
        ValidationUtils.validateArg(value > 0, "bases per line must be 1 or greater");
        return value;
    }

    public FastaReferenceWriterBuilder setFastaFile(Path fastaFile) {
        this.fastaFile = fastaFile;
        this.fastaOutput = null;
        return this;
    }

    public FastaReferenceWriterBuilder setMakeFaiOutput(boolean makeFaiOutput) {
        this.makeFaiOutput = makeFaiOutput;
        return this;
    }

    public FastaReferenceWriterBuilder setMakeDictOutput(boolean makeDictOutput) {
        this.makeDictOutput = makeDictOutput;
        return this;
    }

    public FastaReferenceWriterBuilder setBasesPerLine(int basesPerLine) {
        this.basesPerLine = basesPerLine;
        return this;
    }

    public FastaReferenceWriterBuilder setIndexFile(Path indexFile) {
        this.indexFile = indexFile;
        this.indexOutput = null;
        return this;
    }

    public FastaReferenceWriterBuilder setDictFile(Path dictFile) {
        this.dictFile = dictFile;
        this.dictOutput = null;
        return this;
    }

    public FastaReferenceWriterBuilder setFastaOutput(OutputStream fastaOutput) {
        this.fastaOutput = fastaOutput;
        this.fastaFile = null;
        return this;
    }

    public FastaReferenceWriterBuilder setIndexOutput(OutputStream indexOutput) {
        this.indexOutput = indexOutput;
        this.indexFile = null;
        return this;
    }

    public FastaReferenceWriterBuilder setDictOutput(OutputStream dictOutput) {
        this.dictOutput = dictOutput;
        this.dictFile = null;
        return this;
    }

    public FastaReferenceWriter build() throws IOException {
        if (this.fastaFile == null && this.fastaOutput == null) {
            throw new IllegalArgumentException("Both fastaFile and fastaOutput were null. Please set one of them to be non-null.");
        }
        if (this.fastaFile != null) {
            if (this.indexFile == null && this.indexOutput == null) {
                this.indexFile = FastaReferenceWriterBuilder.defaultFaiFile(this.makeFaiOutput, this.fastaFile);
            } else if (this.indexFile != null && this.indexOutput != null) {
                throw new IllegalArgumentException("Both indexFile and indexOutput were non-null. Please set one of them to be null.");
            }
            if (this.dictFile == null && this.dictOutput == null) {
                this.dictFile = FastaReferenceWriterBuilder.defaultDictFile(this.makeDictOutput, this.fastaFile);
            } else if (this.dictFile != null && this.dictOutput != null) {
                throw new IllegalArgumentException("Both dictFile and dictOutput were non-null. Please set one of them to be null.");
            }
        }
        FastaReferenceWriterBuilder.checkBasesPerLine(this.basesPerLine);
        if (this.fastaFile != null) {
            this.fastaOutput = new BufferedOutputStream(Files.newOutputStream(this.fastaFile, new OpenOption[0]));
        }
        if (this.indexFile != null) {
            this.indexOutput = new BufferedOutputStream(Files.newOutputStream(this.indexFile, new OpenOption[0]));
        }
        if (this.dictFile != null) {
            this.dictOutput = new BufferedOutputStream(Files.newOutputStream(this.dictFile, new OpenOption[0]));
        }
        return new FastaReferenceWriter(this.basesPerLine, this.emitMd5, this.fastaOutput, this.indexOutput, this.dictOutput);
    }

    public boolean getEmitMd5() {
        return this.emitMd5;
    }

    public FastaReferenceWriterBuilder setEmitMd5(boolean emitMd5) {
        this.emitMd5 = emitMd5;
        return this;
    }
}

