/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.BlockCompressedIndexedFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReferenceSequenceFileFactory {
    public static final Set<String> FASTA_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(".fasta");
            this.add(".fasta.gz");
            this.add(".fa");
            this.add(".fa.gz");
            this.add(".fna");
            this.add(".fna.gz");
            this.add(".txt");
            this.add(".txt.gz");
        }
    });
    public static final String FASTA_INDEX_EXTENSION = ".fai";

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(IOUtil.toPath(file), truncateNamesAtWhitespace, preferIndexed);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        ReferenceSequenceFileFactory.getFastaExtension(path);
        if (truncateNamesAtWhitespace && preferIndexed && ReferenceSequenceFileFactory.canCreateIndexedFastaReader(path)) {
            try {
                return IOUtil.isBlockCompressed(path, true) ? new BlockCompressedIndexedFastaSequenceFile(path) : new IndexedFastaSequenceFile(path);
            }
            catch (IOException e) {
                throw new SAMException("Error opening FASTA: " + path, e);
            }
        }
        return new FastaSequenceFile(path, truncateNamesAtWhitespace);
    }

    public static boolean canCreateIndexedFastaReader(Path fastaFile) {
        ReferenceSequenceFileFactory.getFastaExtension(fastaFile);
        if (Files.exists(fastaFile, new LinkOption[0]) && Files.exists(ReferenceSequenceFileFactory.getFastaIndexFileName(fastaFile), new LinkOption[0])) {
            try {
                return !IOUtil.isBlockCompressed(fastaFile, true) || Files.exists(GZIIndex.resolveIndexNameForBgzipFile(fastaFile), new LinkOption[0]);
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(String source, SeekableStream in, FastaSequenceIndex index) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(source, in, index, null, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(String source, SeekableStream in, FastaSequenceIndex index, SAMSequenceDictionary dictionary, boolean truncateNamesAtWhitespace) {
        if (truncateNamesAtWhitespace && index != null) {
            return new IndexedFastaSequenceFile(source, in, index, dictionary);
        }
        return new FastaSequenceFile(source, in, dictionary, truncateNamesAtWhitespace);
    }

    public static File getDefaultDictionaryForReferenceSequence(File file) {
        return ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(IOUtil.toPath(file)).toFile();
    }

    public static Path getDefaultDictionaryForReferenceSequence(Path path) {
        String name = path.getFileName().toString();
        int extensionIndex = name.length() - ReferenceSequenceFileFactory.getFastaExtension(path).length();
        return path.resolveSibling(name.substring(0, extensionIndex) + ".dict");
    }

    public static SAMSequenceDictionary loadDictionary(InputStream in) {
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        BufferedLineReader reader = new BufferedLineReader(in);
        SAMFileHeader header = codec.decode(reader, null);
        if (header.getSequenceDictionary().isEmpty()) {
            return null;
        }
        return header.getSequenceDictionary();
    }

    public static String getFastaExtension(Path path) {
        String name = path.getFileName().toString();
        return FASTA_EXTENSIONS.stream().filter(name::endsWith).findFirst().orElseGet(() -> {
            throw new IllegalArgumentException("File is not a supported reference file type: " + path.toAbsolutePath());
        });
    }

    public static Path getFastaIndexFileName(Path fastaFile) {
        return fastaFile.resolveSibling(fastaFile.getFileName() + FASTA_INDEX_EXTENSION);
    }
}

