/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.example;

import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import java.io.File;

public class IndicesAreEqual {
    public static void main(String[] args) {
        if (args.length != 2) {
            IndicesAreEqual.printUsage();
        } else {
            Index index1 = IndicesAreEqual.loadIndex(args[0]);
            Index index2 = IndicesAreEqual.loadIndex(args[1]);
            System.out.printf("%n", new Object[0]);
            System.out.printf("index1: %s%n", args[0]);
            System.out.printf("index2: %s%n", args[1]);
            boolean eq = index1.equals(index2);
            System.out.printf("  equals() = %b%n", eq);
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar IndicesAreEqual.jar index1 index2");
        System.err.println("    Prints out true / false if index1 and index2 are equal");
        System.exit(1);
    }

    public static Index loadIndex(String filename) {
        File file = new File(filename);
        if (file.canRead()) {
            return IndexFactory.loadIndex(file.getAbsolutePath());
        }
        IndicesAreEqual.printUsage();
        return null;
    }
}

