/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import java.net.URL;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class BrowserUtils {
    private static final Logger logger = Logger.getLogger(BrowserUtils.class);

    public static final void open(URL url) throws Exception {
        BrowserUtils.open(url.toString());
    }

    public static final void open(String URL2) throws Exception {
        logger.info(OSNativeUtils.isWindows());
        if (OSNativeUtils.isWindows()) {
            BrowserUtils.openBroswerWindows(URL2);
        } else if (OSNativeUtils.isMac()) {
            BrowserUtils.openBroswerOSX(URL2);
        } else {
            BrowserUtils.openBroswerLINUX(URL2);
        }
    }

    private static void openBroswerWindows(String url) throws Exception {
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    private static void openBroswerOSX(String url) throws Exception {
        Runtime.getRuntime().exec("open " + url);
    }

    private static void openBroswerLINUX(String url) throws Exception {
        Process p = Runtime.getRuntime().exec("which firefox");
        if (p.waitFor() == 0) {
            Runtime.getRuntime().exec("firefox " + url);
            return;
        }
        p = Runtime.getRuntime().exec("which netscape");
        if (p.waitFor() == 0) {
            Runtime.getRuntime().exec("netscape " + url);
            return;
        }
        p = Runtime.getRuntime().exec("which opera");
        if (p.waitFor() == 0) {
            Runtime.getRuntime().exec("opera " + url);
            return;
        }
    }
}

