/*
 * Decompiled with CFR 0.152.
 */
package aliview.aligner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class MuscleWrapper {
    private static final Logger logger = Logger.getLogger(MuscleWrapper.class);

    public static void main(String[] args) {
        MuscleWrapper.getMusclePath();
    }

    public static File getMusclePath() {
        File localMuscleBinFile = new File(MuscleWrapper.getAliViewUserDataDirectory(), "/binaries" + File.separator + MuscleWrapper.getMuscleBinDependingOnOS());
        if (!localMuscleBinFile.exists() || localMuscleBinFile.length() == 0L || localMuscleBinFile.lastModified() < 1395868152000L) {
            ClassLoader cl = MuscleWrapper.class.getClassLoader();
            try {
                boolean fileISOK = false;
                for (int nTries = 0; !fileISOK && nTries <= 3; ++nTries) {
                    InputStream muscleStreamFromJar = cl.getResourceAsStream(localMuscleBinFile.getName());
                    logger.info(muscleStreamFromJar);
                    MuscleWrapper.copyMuscleFileToLocalDir(muscleStreamFromJar, localMuscleBinFile);
                    muscleStreamFromJar = cl.getResourceAsStream(localMuscleBinFile.getName());
                    fileISOK = MuscleWrapper.verifyMD5(muscleStreamFromJar, localMuscleBinFile);
                    if (!fileISOK) {
                        FileUtils.deleteQuietly(localMuscleBinFile);
                        continue;
                    }
                    localMuscleBinFile.setExecutable(true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.info(localMuscleBinFile);
        return localMuscleBinFile;
    }

    private static boolean verifyMD5(InputStream streamFromJar, File localMuscleBinFile) throws FileNotFoundException {
        boolean checksumOK = false;
        String checksum1 = MuscleWrapper.checkSum(streamFromJar);
        String checksum2 = MuscleWrapper.checkSum(new FileInputStream(localMuscleBinFile));
        logger.info(checksum1);
        logger.info(checksum2);
        if (checksum1 != null && checksum2 != null && checksum1.equals(checksum2)) {
            checksumOK = true;
        }
        return checksumOK;
    }

    private static void copyMuscleFileToLocalDir(InputStream muscleStreamFromJar, File localMuscleBinFile) throws IOException {
        FileUtils.forceMkdir(localMuscleBinFile.getParentFile());
        FileUtils.copyInputStreamToFile(muscleStreamFromJar, localMuscleBinFile);
    }

    public static final String getAliViewUserDataDirectory() {
        return System.getProperty("user.home") + File.separator + ".AliView";
    }

    public static final String getMuscleBinDependingOnOS() {
        String binName = "";
        binName = OSNativeUtils.is64BitOS() ? (OSNativeUtils.isMac() ? "muscle3.8.31_i86darwin64" : (OSNativeUtils.isLinuxOrUnix() ? "muscle3.8.425_i86linux64" : "muscle3.8.425_win32.exe")) : (OSNativeUtils.isMac() ? (OSNativeUtils.isPowerPC() ? "muscle3.8.31_macppc" : "muscle3.8.31_i86darwin32") : (OSNativeUtils.isLinuxOrUnix() ? "muscle3.8.425_i86linux32" : "muscle3.8.425_win32.exe"));
        return binName;
    }

    public static String checkSum(InputStream instream) {
        String checksum = null;
        try {
            int numOfBytesRead;
            BufferedInputStream bis = new BufferedInputStream(instream);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((numOfBytesRead = bis.read(buffer)) > 0) {
                md.update(buffer, 0, numOfBytesRead);
            }
            byte[] hash = md.digest();
            checksum = new BigInteger(1, hash).toString(16);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return checksum;
    }
}

