/*
 * Decompiled with CFR 0.152.
 */
package aliview.alignment;

import aliview.AminoAcid;
import aliview.sequences.Sequence;

public abstract class AliHistogram {
    int[][] hist;

    public AliHistogram(int length) {
        this.hist = new int[length][33];
    }

    public abstract void addSequence(Sequence var1);

    public int getValueCount(int x, int value) {
        return this.hist[x][value];
    }

    public int getValueCount(int x, int[] values) {
        int sum = 0;
        for (int value : values) {
            sum += this.hist[x][value];
        }
        return sum;
    }

    public abstract double getSumNonGap(int var1);

    public int getValueCount(int x, AminoAcid acid) {
        return this.getValueCount(x, acid.intVal);
    }

    public double getValueCount(int x, AminoAcid[] acids) {
        int sum = 0;
        for (AminoAcid acid : acids) {
            sum += this.getValueCount(x, acid);
        }
        return sum;
    }

    public double getProportionCount(int x, AminoAcid acid) {
        return (double)this.getValueCount(x, acid) / this.getSumNonGap(x);
    }

    public double getProportionCount(int x, AminoAcid[] acids) {
        return this.getValueCount(x, acids) / this.getSumNonGap(x);
    }

    public double getProportionCount(int x, int value) {
        return (double)this.getValueCount(x, value) / this.getSumNonGap(x);
    }

    public double getProportionCount(int x, int[] values) {
        return (double)this.getValueCount(x, values) / this.getSumNonGap(x);
    }

    public boolean isMajorityRuleConsensus(int x, int baseVal) {
        return this.getProportionCount(x, baseVal) >= 0.5;
    }
}

