/*
 * Decompiled with CFR 0.152.
 */
package aliview.externalcommands;

import aliview.AliView;
import aliview.externalcommands.CommandItem;
import aliview.subprocesses.SubProcessWindow;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExternalCommandExecutor {
    private static final Logger logger = Logger.getLogger(ExternalCommandExecutor.class);
    private static final String LF = System.getProperty("line.separator");

    public static boolean executeMultiple(CommandItem cmdItem, SubProcessWindow subProcessWin) throws IOException {
        boolean wasProcessInterrupted = false;
        for (String[] commandLine : cmdItem.getParsedCommands()) {
            if (StringUtils.startsWith(commandLine[0], "ALIVIEW_")) {
                ExternalCommandExecutor.executeInternalCommand(commandLine, subProcessWin);
                continue;
            }
            wasProcessInterrupted = ExternalCommandExecutor.executeCommand(commandLine, subProcessWin);
            if (!subProcessWin.wasSubProcessDestrouedByUser()) continue;
            wasProcessInterrupted = true;
            break;
        }
        return wasProcessInterrupted;
    }

    private static void executeInternalCommand(final String[] commandLine, final SubProcessWindow subProcessWin) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (commandLine[0].equals("ALIVIEW_OPEN")) {
                        AliView.openAlignmentFile(new File(commandLine[1]));
                    } else {
                        subProcessWin.appendOutput("Failed: - Non recognized command: " + commandLine[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean executeCommand(String[] commandArray, SubProcessWindow subProcessWin) throws IOException {
        boolean wasProcessInterrupted = false;
        File pipedOut = null;
        for (int i = 0; i < commandArray.length; ++i) {
            if (!commandArray[i].equals(">")) continue;
            logger.info("found pipe");
            if (commandArray.length < i + 1) continue;
            pipedOut = new File(commandArray[i + 1]);
            commandArray = (String[])ArrayUtils.subarray(commandArray, 0, i);
            break;
        }
        String cmdAsString = "";
        for (String part : commandArray) {
            cmdAsString = cmdAsString + " " + part;
        }
        logger.info(cmdAsString);
        ProcessBuilder probuilder = new ProcessBuilder(commandArray);
        probuilder.redirectErrorStream(true);
        Process subprocess = probuilder.start();
        subProcessWin.setActiveProcess(subprocess);
        subProcessWin.appendOutput("command:" + LF + cmdAsString + LF);
        Scanner sc = new Scanner(subprocess.getInputStream());
        while (sc.hasNext()) {
            String nextLine = sc.nextLine();
            subProcessWin.appendOutput(nextLine + LF);
            System.out.println(nextLine);
        }
        sc.close();
        logger.info("errorReaderThread-finished");
        logger.info("before wait for subprocess");
        subprocess.destroy();
        logger.info("done");
        return wasProcessInterrupted;
    }
}

