/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.gui.pane.RGBArray;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CharPixels {
    private static final Logger logger = Logger.getLogger(CharPixels.class);
    public static final int CASE_UNTOUCHED = 0;
    public static final int CASE_UPPER = 1;
    public static final int CASE_LOWER = 2;
    private char ch;
    private Color color;
    private volatile RGBArray rgbArray;
    private int width;
    private int height;
    private Graphics2D g2;
    private Color bgColor;
    private Color fgColor;
    private Font font;
    private int minFontSize;
    private int fontCase;

    public CharPixels(char ch, int width, int height, Color fgColor, Color bgColor, Font font, int minFontSize, int fontCase) {
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        this.ch = ch;
        this.width = width;
        this.height = height;
        this.font = font;
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.minFontSize = minFontSize;
        this.fontCase = fontCase;
    }

    public int[] getPixels() {
        return this.getRGBArray().getBackend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RGBArray getRGBArray() {
        if (this.rgbArray == null) {
            CharPixels charPixels = this;
            synchronized (charPixels) {
                if (this.rgbArray == null) {
                    BufferedImage bi = this.createPixelImageBufferedImage();
                    int[] origData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                    int[] pixCopy = Arrays.copyOf(origData, origData.length);
                    this.rgbArray = new RGBArray(pixCopy, this.width, this.height);
                }
            }
        }
        return this.rgbArray;
    }

    private BufferedImage createPixelImageBufferedImage() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 2);
        this.g2 = bi.createGraphics();
        this.g2.setFont(this.font);
        this.g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2.setColor(this.bgColor);
        this.g2.fillRect(0, 0, this.width, this.height);
        if (this.width > this.minFontSize) {
            this.g2.setColor(this.fgColor);
            int leftCharOffset = (int)(0.15 * (double)this.width);
            int bottomCharOffset = (int)(0.2 * (double)this.height);
            char displayChar = this.ch;
            if (this.fontCase == 1) {
                displayChar = Character.toUpperCase(this.ch);
            } else if (this.fontCase == 2) {
                displayChar = Character.toLowerCase(this.ch);
            }
            this.g2.drawString("" + displayChar, leftCharOffset, this.height - bottomCharOffset);
        }
        return bi;
    }
}

