/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.gui.pane.CharPixels;
import aliview.gui.pane.RGBArray;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CharPixelsBothNucAndAA
extends CharPixels {
    private static final Logger logger = Logger.getLogger(CharPixelsBothNucAndAA.class);
    public static final int CASE_UNTOUCHED = 0;
    public static final int CASE_UPPER = 1;
    public static final int CASE_LOWER = 2;
    private Color color;
    private RGBArray rgbArray;
    private int width;
    private int height;
    private BufferedImage bi;
    private Graphics2D g2;
    private Font font;
    private int minFontSize;
    private int fontCase;
    private Color nucFgColor;
    private Color nucBgColor;
    private Color aaBgColor;
    private Color aaFgColor;
    private char chAA;
    private char chNuc;

    public CharPixelsBothNucAndAA(char chNuc, char chAA, int width, int height, Color nucFgColor, Color nucBgColor, Color aaFgColor, Color aaBgColor, Font font, int minFontSize, int fontCase) {
        super(chAA, width, height, aaFgColor, aaBgColor, font, minFontSize, fontCase);
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        this.chAA = chAA;
        this.chNuc = chNuc;
        this.width = width;
        this.height = height;
        this.font = font;
        this.nucFgColor = nucFgColor;
        this.nucBgColor = nucBgColor;
        this.aaFgColor = aaFgColor;
        this.aaBgColor = aaBgColor;
        this.minFontSize = minFontSize;
        this.fontCase = fontCase;
    }

    public int[] getPixels() {
        return this.getRGBArray().getBackend();
    }

    public RGBArray getRGBArray() {
        if (this.rgbArray == null) {
            BufferedImage bi = this.createPixelImageFromStaticBufferedImage();
            int[] origData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            int[] pixCopy = Arrays.copyOf(origData, origData.length);
            this.rgbArray = new RGBArray(pixCopy, this.width, this.height);
        }
        return this.rgbArray;
    }

    private BufferedImage createPixelImageFromStaticBufferedImage() {
        char displayChar;
        int bottomCharOffset;
        int leftCharOffset;
        if (this.bi == null) {
            this.bi = new BufferedImage(this.width, this.height, 2);
            this.g2 = this.bi.createGraphics();
            this.g2.setFont(this.font);
            this.g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.g2.setColor(this.aaBgColor);
        this.g2.fillRect(0, 0, this.width, this.height / 2);
        if (this.width > this.minFontSize) {
            this.g2.setColor(this.aaFgColor);
            leftCharOffset = (int)(0.15 * (double)this.width);
            bottomCharOffset = (int)(0.2 * (double)this.height / 2.0);
            displayChar = this.chAA;
            if (this.fontCase == 1) {
                displayChar = Character.toUpperCase(this.chAA);
            } else if (this.fontCase == 2) {
                displayChar = Character.toLowerCase(this.chAA);
            }
            this.g2.drawString("" + displayChar, leftCharOffset, this.height / 2 - bottomCharOffset);
        }
        this.g2.setColor(this.nucBgColor);
        this.g2.fillRect(0, 0 + this.height / 2, this.width, this.height / 2);
        if (this.width > this.minFontSize) {
            this.g2.setColor(this.nucFgColor);
            leftCharOffset = (int)(0.15 * (double)this.width);
            bottomCharOffset = (int)(0.2 * (double)this.height / 2.0);
            displayChar = this.chNuc;
            if (this.fontCase == 1) {
                displayChar = Character.toUpperCase(this.chNuc);
            } else if (this.fontCase == 2) {
                displayChar = Character.toLowerCase(this.chNuc);
            }
            this.g2.drawString("" + displayChar, leftCharOffset, this.height - bottomCharOffset);
        }
        return this.bi;
    }
}

