/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.AminoAcid;
import aliview.alignment.Alignment;
import aliview.gui.pane.AlignmentPane;
import aliview.gui.pane.ImageUtils;
import aliview.gui.pane.RGBArray;
import aliview.gui.pane.SequencePainter;
import aliview.gui.pane.TranslationCharPixelsContainer;
import aliview.sequences.Sequence;
import org.apache.log4j.Logger;

public class SequencePainterAminoAcidTranslated
extends SequencePainter {
    private static final Logger logger = Logger.getLogger(SequencePainterAminoAcidTranslated.class);

    public SequencePainterAminoAcidTranslated(Sequence seq, int seqYPos, int clipPosY, int xMinSeqPos, int xMaxSeqPos, double seqPerPix, double charWidth, double charHeight, double highDPIScaleFactor, RGBArray clipRGB, AlignmentPane aliPane, Alignment alignment) {
        super(seq, seqYPos, clipPosY, xMinSeqPos, xMaxSeqPos, seqPerPix, charWidth, charHeight, highDPIScaleFactor, clipRGB, aliPane, alignment);
    }

    protected void copyPixels(Sequence seq, RGBArray clipRGB, int seqXPos, int seqYPos, int pixelPosX, int pixelPosY, AlignmentPane aliPane, Alignment alignment) {
        RGBArray newPiece;
        byte residue = seq.getBaseAtPos(seqXPos);
        AminoAcid acid = seq.getTranslatedAminoAcidAtNucleotidePos(seqXPos);
        TranslationCharPixelsContainer pixContainerToUse = aliPane.charPixTranslationDefault;
        TranslationCharPixelsContainer pixLetterContainerToUse = aliPane.charPixTranslationLetter;
        TranslationCharPixelsContainer pixLetterContainerToUseNoAALetter = aliPane.charPixTranslationDefault;
        boolean isPointWithinSelectionRect = false;
        if (alignment.getTempSelection() != null && (double)seqXPos <= alignment.getTempSelection().getMaxX() && (double)seqXPos >= alignment.getTempSelection().getMinX() && (double)seqYPos <= alignment.getTempSelection().getMaxY() && (double)seqYPos >= alignment.getTempSelection().getMinY()) {
            isPointWithinSelectionRect = true;
        }
        if (seq.isBaseSelected(seqXPos) || alignment.getTempSelection() != null && isPointWithinSelectionRect) {
            pixContainerToUse = aliPane.charPixTranslationSelected;
            pixLetterContainerToUse = aliPane.charPixTranslationSelectedLetter;
        }
        if (!aliPane.isDrawAminoAcidCode()) {
            newPiece = pixContainerToUse.getRGBArray(acid, residue);
        } else if (seq.isCodonSecondPos(seqXPos)) {
            newPiece = pixLetterContainerToUse.getRGBArray(acid, residue);
        } else {
            residue = 32;
            newPiece = pixLetterContainerToUseNoAALetter.getRGBArray(acid, residue);
        }
        try {
            ImageUtils.insertRGBArrayAt(pixelPosX, pixelPosY, newPiece, clipRGB);
        }
        catch (Exception e) {
            logger.info("clipX" + pixelPosX);
            logger.info("clipY" + pixelPosY);
        }
    }
}

