/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.NucleotideUtilities;
import aliview.alignment.Alignment;
import aliview.alignment.NucleotideHistogram;
import aliview.gui.pane.AlignmentPane;
import aliview.gui.pane.CharPixelsContainer;
import aliview.gui.pane.ImageUtils;
import aliview.gui.pane.RGBArray;
import aliview.gui.pane.SequencePainter;
import aliview.sequences.Sequence;
import org.apache.log4j.Logger;

public class SequencePainterNucleotide
extends SequencePainter {
    private static final Logger logger = Logger.getLogger(SequencePainterNucleotide.class);

    public SequencePainterNucleotide(Sequence seq, int seqYPos, int clipPosY, int xMinSeqPos, int xMaxSeqPos, double step, double charWidth, double charHeight, double highDPIScaleFactor, RGBArray clipRGB, AlignmentPane aliPane, Alignment alignment) {
        super(seq, seqYPos, clipPosY, xMinSeqPos, xMaxSeqPos, step, charWidth, charHeight, highDPIScaleFactor, clipRGB, aliPane, alignment);
    }

    protected void copyPixels(Sequence seq, RGBArray clipArray, int seqXPos, int seqYPos, int pixelPosX, int pixelPosY, AlignmentPane aliPane, Alignment alignment) {
        NucleotideHistogram nucHistogram;
        byte residue = seq.getBaseAtPos(seqXPos);
        if (residue == 0) {
            residue = 32;
        }
        CharPixelsContainer pixContainerToUse = aliPane.charPixDefaultNuc;
        byte byteToDraw = residue;
        int baseVal = NucleotideUtilities.baseValFromBase(residue);
        if (aliPane.isHighlightDiffTrace() && seqYPos != aliPane.differenceTraceSequencePosition && baseVal == NucleotideUtilities.baseValFromBase(alignment.getBaseAt(seqXPos, aliPane.getDifferenceTraceSequencePosition()))) {
            byteToDraw = 46;
            pixContainerToUse = aliPane.charPixDefaultNuc;
        }
        if (aliPane.isHighlightNonCons()) {
            nucHistogram = (NucleotideHistogram)alignment.getHistogram();
            if (baseVal != 0 && nucHistogram.isMajorityRuleConsensus(seqXPos, baseVal)) {
                pixContainerToUse = aliPane.charPixConsensusNuc;
            }
        }
        if (aliPane.highlightCons) {
            nucHistogram = (NucleotideHistogram)alignment.getHistogram();
            if (baseVal != 0 && !nucHistogram.isMajorityRuleConsensus(seqXPos, baseVal)) {
                pixContainerToUse = aliPane.charPixConsensusNuc;
            }
        }
        boolean isPointWithinSelectionRect = false;
        if (alignment.getTempSelection() != null && (double)seqXPos <= alignment.getTempSelection().getMaxX() && (double)seqXPos >= alignment.getTempSelection().getMinX() && (double)seqYPos <= alignment.getTempSelection().getMaxY() && (double)seqYPos >= alignment.getTempSelection().getMinY()) {
            isPointWithinSelectionRect = true;
        }
        if (seq.isBaseSelected(seqXPos) || alignment.getTempSelection() != null && isPointWithinSelectionRect) {
            pixContainerToUse = aliPane.charPixSelectedNuc;
        }
        RGBArray newPiece = pixContainerToUse.getRGBArray(byteToDraw);
        try {
            ImageUtils.insertRGBArrayAt(pixelPosX, pixelPosY, newPiece, clipArray);
        }
        catch (Exception e) {
            logger.info("x" + seqXPos);
            logger.info("y" + seqYPos);
            logger.info("clipX" + pixelPosX);
            logger.info("clipY" + pixelPosY);
        }
    }
}

