/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.GeneticCode;
import aliview.MemoryUtils;
import aliview.alignment.Alignment;
import aliview.alignment.AlignmentFile;
import aliview.alignment.AlignmentMeta;
import aliview.importer.AlignmentImportException;
import aliview.importer.SequencesFactory;
import aliview.messenges.Messenger;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.FileSequenceAlignmentListModel;
import aliview.sequences.NexusSequence;
import aliview.sequences.SequenceUtils;
import aliview.settings.Settings;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import utils.nexus.CharSets;
import utils.nexus.CodonPositions;
import utils.nexus.Excludes;
import utils.nexus.NexusAlignmentImportException;
import utils.nexus.NexusUtilities;

public class AlignmentFactory {
    private static final String LF = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger(AlignmentFactory.class);
    private static final SequencesFactory seqFactory = new SequencesFactory();

    public static Alignment createNewAlignment(File alignmentFile) {
        return AlignmentFactory.createNewAlignment(alignmentFile, SequenceUtils.TYPE_UNKNOWN);
    }

    public static Alignment createNewAlignment(File alignmentFile, int sequenceType) {
        HashSet<String> duplicateSeqNames;
        boolean hideMessage;
        logger.info("inside createNewAlignment");
        long startTime = System.currentTimeMillis();
        Alignment alignment = null;
        try {
            AlignmentListModel sequences = seqFactory.createSequences(alignmentFile);
            Excludes excludes = new Excludes();
            CodonPositions codonPositions = new CodonPositions();
            CharSets charsets = new CharSets();
            logger.info("sequences.getLongestSequenceLength()" + sequences.getLongestSequenceLength());
            try {
                if (NexusUtilities.isNexusFile(alignmentFile) && !(sequences instanceof FileSequenceAlignmentListModel) && !(sequences.get(0) instanceof NexusSequence)) {
                    NexusUtilities.updateExcludesFromFile(alignmentFile, excludes);
                    NexusUtilities.updateCodonPositionsFromNexusFile(alignmentFile, codonPositions);
                    charsets = NexusUtilities.createCharsetsFromNexusFile(alignmentFile, sequences.getLongestSequenceLength());
                } else {
                    File metaFile = new File(alignmentFile.getAbsolutePath() + ".meta");
                    if (metaFile.exists()) {
                        NexusUtilities.updateExcludesFromFile(metaFile, excludes);
                        NexusUtilities.updateCodonPositionsFromNexusFile(metaFile, codonPositions);
                        charsets = NexusUtilities.createCharsetsFromNexusFile(metaFile, sequences.getLongestSequenceLength());
                    }
                }
            }
            catch (NexusAlignmentImportException e) {
                e.printStackTrace();
                logger.error(e);
                Messenger.showOKOnlyMessage(Messenger.ALIGNMENT_META_READ_ERROR, LF + e.getLocalizedMessage());
            }
            MemoryUtils.logMem();
            AlignmentMeta aliMeta = new AlignmentMeta(excludes, codonPositions, charsets, GeneticCode.DEFAULT);
            if (sequenceType != SequenceUtils.TYPE_UNKNOWN) {
                sequences.setSequenceType(sequenceType);
            }
            alignment = new Alignment(alignmentFile, sequences, aliMeta);
            MemoryUtils.logMem();
        }
        catch (AlignmentImportException e) {
            e.printStackTrace();
            logger.error(e);
            Messenger.showOKOnlyMessage(Messenger.ALIGNMENT_IMPORT_ERROR, LF + e.getLocalizedMessage());
        }
        if (alignment != null && !(hideMessage = Settings.getHideDuplicateSeqNamesMessage().getBooleanValue()) && (duplicateSeqNames = alignment.findDuplicateNames()) != null && duplicateSeqNames.size() > 0) {
            alignment.selectDuplicateNamesSequences();
            Messenger.showDuplicateSeqNamesMessage(duplicateSeqNames);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Importing sequences took " + (endTime - startTime) + " milliseconds");
        return alignment;
    }

    public static Alignment createNewAlignment(String alignmentText) {
        Alignment alignment = null;
        try {
            logger.info("ali" + alignmentText);
            AlignmentFile tempAliFile = AlignmentFile.createAliViewTempFile("clipboard-alignment", "");
            FileUtils.writeStringToFile(tempAliFile, alignmentText);
            alignment = AlignmentFactory.createNewAlignment(tempAliFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return alignment;
    }

    public static Alignment createNewEmptyAlignment() {
        return new Alignment();
    }
}

